@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin

import com.pulumi.azurenative.logz.MetricsSourceTagRuleArgs.builder
import com.pulumi.azurenative.logz.kotlin.inputs.MetricsTagRulesPropertiesArgs
import com.pulumi.azurenative.logz.kotlin.inputs.MetricsTagRulesPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Capture metrics of Azure resources based on ARM tags.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * ## Example Usage
 * ### MetricsSourceTagRules_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricsSourceTagRule = new AzureNative.Logz.MetricsSourceTagRule("metricsSourceTagRule", new()
 *     {
 *         MetricsSourceName = "MetricsSource1",
 *         MonitorName = "myMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *         RuleSetName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logz/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logz.NewMetricsSourceTagRule(ctx, "metricsSourceTagRule", &logz.MetricsSourceTagRuleArgs{
 * 			MetricsSourceName: pulumi.String("MetricsSource1"),
 * 			MonitorName:       pulumi.String("myMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RuleSetName:       pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logz.MetricsSourceTagRule;
 * import com.pulumi.azurenative.logz.MetricsSourceTagRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricsSourceTagRule = new MetricsSourceTagRule("metricsSourceTagRule", MetricsSourceTagRuleArgs.builder()
 *             .metricsSourceName("MetricsSource1")
 *             .monitorName("myMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .ruleSetName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logz:MetricsSourceTagRule default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/metricsSource/{metricsSourceName}/tagRules/{ruleSetName}
 * ```
 * @property metricsSourceName Metrics Account resource name
 * @property monitorName Monitor resource name
 * @property properties Definition of the properties for a TagRules resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleSetName
 */
public data class MetricsSourceTagRuleArgs(
    public val metricsSourceName: Output<String>? = null,
    public val monitorName: Output<String>? = null,
    public val properties: Output<MetricsTagRulesPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleSetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.MetricsSourceTagRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.MetricsSourceTagRuleArgs =
        com.pulumi.azurenative.logz.MetricsSourceTagRuleArgs.builder()
            .metricsSourceName(metricsSourceName?.applyValue({ args0 -> args0 }))
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleSetName(ruleSetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricsSourceTagRuleArgs].
 */
@PulumiTagMarker
public class MetricsSourceTagRuleArgsBuilder internal constructor() {
    private var metricsSourceName: Output<String>? = null

    private var monitorName: Output<String>? = null

    private var properties: Output<MetricsTagRulesPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleSetName: Output<String>? = null

    /**
     * @param value Metrics Account resource name
     */
    @JvmName("urydunjjcbwtyqxk")
    public suspend fun metricsSourceName(`value`: Output<String>) {
        this.metricsSourceName = value
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("bxdjbbppjeorbwyc")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value Definition of the properties for a TagRules resource.
     */
    @JvmName("avgycufvcwpwckxi")
    public suspend fun properties(`value`: Output<MetricsTagRulesPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("raectxlyiqtnawsh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("gmvlkhseiywgardq")
    public suspend fun ruleSetName(`value`: Output<String>) {
        this.ruleSetName = value
    }

    /**
     * @param value Metrics Account resource name
     */
    @JvmName("fymitebejjrmunxd")
    public suspend fun metricsSourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricsSourceName = mapped
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("stacxngvvagnijlb")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value Definition of the properties for a TagRules resource.
     */
    @JvmName("kqiqsrooxviykkfi")
    public suspend fun properties(`value`: MetricsTagRulesPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Definition of the properties for a TagRules resource.
     */
    @JvmName("ibfcghyxgcxypjpy")
    public suspend fun properties(argument: suspend MetricsTagRulesPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MetricsTagRulesPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("juipmfnxxtfksprc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("qsmcvsdqvyroagky")
    public suspend fun ruleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSetName = mapped
    }

    internal fun build(): MetricsSourceTagRuleArgs = MetricsSourceTagRuleArgs(
        metricsSourceName = metricsSourceName,
        monitorName = monitorName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        ruleSetName = ruleSetName,
    )
}
