@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin

import com.pulumi.azurenative.logz.TagRuleArgs.builder
import com.pulumi.azurenative.logz.kotlin.inputs.MonitoringTagRulesPropertiesArgs
import com.pulumi.azurenative.logz.kotlin.inputs.MonitoringTagRulesPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Capture logs and metrics of Azure resources based on ARM tags.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2020-10-01.
 * ## Example Usage
 * ### TagRules_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagRule = new AzureNative.Logz.TagRule("tagRule", new()
 *     {
 *         MonitorName = "myMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *         RuleSetName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logz/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logz.NewTagRule(ctx, "tagRule", &logz.TagRuleArgs{
 * 			MonitorName:       pulumi.String("myMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RuleSetName:       pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logz.TagRule;
 * import com.pulumi.azurenative.logz.TagRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagRule = new TagRule("tagRule", TagRuleArgs.builder()
 *             .monitorName("myMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .ruleSetName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logz:TagRule default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/tagRules/{ruleSetName}
 * ```
 * @property monitorName Monitor resource name
 * @property properties Definition of the properties for a TagRules resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleSetName
 */
public data class TagRuleArgs(
    public val monitorName: Output<String>? = null,
    public val properties: Output<MonitoringTagRulesPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleSetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.TagRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.TagRuleArgs =
        com.pulumi.azurenative.logz.TagRuleArgs.builder()
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleSetName(ruleSetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagRuleArgs].
 */
@PulumiTagMarker
public class TagRuleArgsBuilder internal constructor() {
    private var monitorName: Output<String>? = null

    private var properties: Output<MonitoringTagRulesPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleSetName: Output<String>? = null

    /**
     * @param value Monitor resource name
     */
    @JvmName("ritdagxikgpcsgxy")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value Definition of the properties for a TagRules resource.
     */
    @JvmName("tqrrblixqlicfsgi")
    public suspend fun properties(`value`: Output<MonitoringTagRulesPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("febbihbmyrufqwog")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("bhorcgrsretrviup")
    public suspend fun ruleSetName(`value`: Output<String>) {
        this.ruleSetName = value
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("cajilyvxfcvcnhca")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value Definition of the properties for a TagRules resource.
     */
    @JvmName("pgblxoyrtikdcxqi")
    public suspend fun properties(`value`: MonitoringTagRulesPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Definition of the properties for a TagRules resource.
     */
    @JvmName("qgjhrlaokwbvsvqv")
    public suspend
    fun properties(argument: suspend MonitoringTagRulesPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MonitoringTagRulesPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("phdktcfhpnwlefwa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("tqlsibboswnyrsvd")
    public suspend fun ruleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSetName = mapped
    }

    internal fun build(): TagRuleArgs = TagRuleArgs(
        monitorName = monitorName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        ruleSetName = ruleSetName,
    )
}
