@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Valid actions for a filtering tag. Exclusion takes priority over inclusion.
 */
public enum class TagAction(
    public val javaValue: com.pulumi.azurenative.logz.enums.TagAction,
) : ConvertibleToJava<com.pulumi.azurenative.logz.enums.TagAction> {
    Include(com.pulumi.azurenative.logz.enums.TagAction.Include),
    Exclude(com.pulumi.azurenative.logz.enums.TagAction.Exclude),
    ;

    override fun toJava(): com.pulumi.azurenative.logz.enums.TagAction = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logz.enums.TagAction): TagAction =
            TagAction.values().first { it.javaValue == javaType }
    }
}
