@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.ListMonitorVMHostsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property monitorName Monitor resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListMonitorVMHostsPlainArgs(
    public val monitorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.ListMonitorVMHostsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.ListMonitorVMHostsPlainArgs =
        com.pulumi.azurenative.logz.inputs.ListMonitorVMHostsPlainArgs.builder()
            .monitorName(monitorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListMonitorVMHostsPlainArgs].
 */
@PulumiTagMarker
public class ListMonitorVMHostsPlainArgsBuilder internal constructor() {
    private var monitorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Monitor resource name
     */
    @JvmName("yewcreldlowsihqn")
    public suspend fun monitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ysbueisdaepwuqsp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListMonitorVMHostsPlainArgs = ListMonitorVMHostsPlainArgs(
        monitorName = monitorName ?: throw PulumiNullFieldException("monitorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
