@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.UserInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property emailAddress Email of the user used by Logz for contacting them if needed
 * @property firstName First Name of the user
 * @property lastName Last Name of the user
 * @property phoneNumber Phone number of the user used by Logz for contacting them if needed
 */
public data class UserInfoArgs(
    public val emailAddress: Output<String>? = null,
    public val firstName: Output<String>? = null,
    public val lastName: Output<String>? = null,
    public val phoneNumber: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.UserInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.UserInfoArgs =
        com.pulumi.azurenative.logz.inputs.UserInfoArgs.builder()
            .emailAddress(emailAddress?.applyValue({ args0 -> args0 }))
            .firstName(firstName?.applyValue({ args0 -> args0 }))
            .lastName(lastName?.applyValue({ args0 -> args0 }))
            .phoneNumber(phoneNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserInfoArgs].
 */
@PulumiTagMarker
public class UserInfoArgsBuilder internal constructor() {
    private var emailAddress: Output<String>? = null

    private var firstName: Output<String>? = null

    private var lastName: Output<String>? = null

    private var phoneNumber: Output<String>? = null

    /**
     * @param value Email of the user used by Logz for contacting them if needed
     */
    @JvmName("ohovmqnvtcqtuxup")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value First Name of the user
     */
    @JvmName("vaxgyjcsshcklbpq")
    public suspend fun firstName(`value`: Output<String>) {
        this.firstName = value
    }

    /**
     * @param value Last Name of the user
     */
    @JvmName("exvaiytrnaprnwqf")
    public suspend fun lastName(`value`: Output<String>) {
        this.lastName = value
    }

    /**
     * @param value Phone number of the user used by Logz for contacting them if needed
     */
    @JvmName("knlakarkmkoqyigr")
    public suspend fun phoneNumber(`value`: Output<String>) {
        this.phoneNumber = value
    }

    /**
     * @param value Email of the user used by Logz for contacting them if needed
     */
    @JvmName("jmnigwikpyilunko")
    public suspend fun emailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value First Name of the user
     */
    @JvmName("achgdrgfcykbhlph")
    public suspend fun firstName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstName = mapped
    }

    /**
     * @param value Last Name of the user
     */
    @JvmName("annsqqwsslyyivgd")
    public suspend fun lastName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastName = mapped
    }

    /**
     * @param value Phone number of the user used by Logz for contacting them if needed
     */
    @JvmName("ljtvasfcboyktbcg")
    public suspend fun phoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumber = mapped
    }

    internal fun build(): UserInfoArgs = UserInfoArgs(
        emailAddress = emailAddress,
        firstName = firstName,
        lastName = lastName,
        phoneNumber = phoneNumber,
    )
}
