@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin

import com.pulumi.azurenative.machinelearning.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.machinelearning.kotlin.outputs.SkuResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Workspace].
 */
@PulumiTagMarker
public class WorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceArgs = WorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceArgsBuilder.() -> Unit) {
        val builder = WorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Workspace {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearning.Workspace(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Workspace(builtJavaResource)
    }
}

/**
 * An object that represents a machine learning workspace.
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2016-04-01.
 * ## Example Usage
 * ### WorkspaceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.MachineLearning.Workspace("workspace", new()
 *     {
 *         Location = "West Europe",
 *         OwnerEmail = "abc@microsoft.com",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.MachineLearning.Inputs.SkuArgs
 *         {
 *             Name = "Enterprise",
 *             Tier = "Enterprise",
 *         },
 *         Tags =
 *         {
 *             { "tagKey1", "TagValue1" },
 *         },
 *         UserStorageAccountId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/teststorage",
 *         WorkspaceName = "testworkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearning/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearning.NewWorkspace(ctx, "workspace", &machinelearning.WorkspaceArgs{
 * 			Location:          pulumi.String("West Europe"),
 * 			OwnerEmail:        pulumi.String("abc@microsoft.com"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &machinelearning.SkuArgs{
 * 				Name: pulumi.String("Enterprise"),
 * 				Tier: pulumi.String("Enterprise"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tagKey1": pulumi.String("TagValue1"),
 * 			},
 * 			UserStorageAccountId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/teststorage"),
 * 			WorkspaceName:        pulumi.String("testworkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearning.Workspace;
 * import com.pulumi.azurenative.machinelearning.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("West Europe")
 *             .ownerEmail("abc@microsoft.com")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Enterprise"),
 *                 Map.entry("tier", "Enterprise")
 *             ))
 *             .tags(Map.of("tagKey1", "TagValue1"))
 *             .userStorageAccountId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/teststorage")
 *             .workspaceName("testworkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearning:Workspace testworkspace /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/workspaces/{workspaceName}
 * ```
 */
public class Workspace internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearning.Workspace,
) : KotlinCustomResource(javaResource, WorkspaceMapper) {
    /**
     * The creation time for this workspace resource.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The key vault identifier used for encrypted workspaces.
     */
    public val keyVaultIdentifierId: Output<String>?
        get() = javaResource.keyVaultIdentifierId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The location of the resource. This cannot be changed after the resource is created.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The email id of the owner for this workspace.
     */
    public val ownerEmail: Output<String>
        get() = javaResource.ownerEmail().applyValue({ args0 -> args0 })

    /**
     * The sku of the workspace.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The regional endpoint for the machine learning studio service which hosts this workspace.
     */
    public val studioEndpoint: Output<String>
        get() = javaResource.studioEndpoint().applyValue({ args0 -> args0 })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The fully qualified arm id of the storage account associated with this workspace.
     */
    public val userStorageAccountId: Output<String>
        get() = javaResource.userStorageAccountId().applyValue({ args0 -> args0 })

    /**
     * The immutable id associated with this workspace.
     */
    public val workspaceId: Output<String>
        get() = javaResource.workspaceId().applyValue({ args0 -> args0 })

    /**
     * The current state of workspace resource.
     */
    public val workspaceState: Output<String>
        get() = javaResource.workspaceState().applyValue({ args0 -> args0 })

    /**
     * The type of this workspace.
     */
    public val workspaceType: Output<String>
        get() = javaResource.workspaceType().applyValue({ args0 -> args0 })
}

public object WorkspaceMapper : ResourceMapper<Workspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearning.Workspace::class == javaResource::class

    override fun map(javaResource: Resource): Workspace = Workspace(
        javaResource as
            com.pulumi.azurenative.machinelearning.Workspace,
    )
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workspace].
 */
public suspend fun workspace(name: String, block: suspend WorkspaceResourceBuilder.() -> Unit):
    Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspace(name: String): Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
