@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.ColumnSpecificationArgs.builder
import com.pulumi.azurenative.machinelearning.kotlin.enums.ColumnFormat
import com.pulumi.azurenative.machinelearning.kotlin.enums.ColumnType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Swagger 2.0 schema for a column within the data table representing a web service input or output. See Swagger specification: http://swagger.io/specification/
 * @property enum If the data type is categorical, this provides the list of accepted categories.
 * @property format Additional format information for the data type.
 * @property type Data type of the column.
 * @property xMsIsnullable Flag indicating if the type supports null values or not.
 * @property xMsIsordered Flag indicating whether the categories are treated as an ordered set or not, if this is a categorical column.
 */
public data class ColumnSpecificationArgs(
    public val `enum`: Output<List<Any>>? = null,
    public val format: Output<Either<String, ColumnFormat>>? = null,
    public val type: Output<Either<String, ColumnType>>,
    public val xMsIsnullable: Output<Boolean>? = null,
    public val xMsIsordered: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.ColumnSpecificationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.ColumnSpecificationArgs =
        com.pulumi.azurenative.machinelearning.inputs.ColumnSpecificationArgs.builder()
            .enum_(`enum`?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .xMsIsnullable(xMsIsnullable?.applyValue({ args0 -> args0 }))
            .xMsIsordered(xMsIsordered?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ColumnSpecificationArgs].
 */
@PulumiTagMarker
public class ColumnSpecificationArgsBuilder internal constructor() {
    private var `enum`: Output<List<Any>>? = null

    private var format: Output<Either<String, ColumnFormat>>? = null

    private var type: Output<Either<String, ColumnType>>? = null

    private var xMsIsnullable: Output<Boolean>? = null

    private var xMsIsordered: Output<Boolean>? = null

    /**
     * @param value If the data type is categorical, this provides the list of accepted categories.
     */
    @JvmName("yweydcrdkotrgodl")
    public suspend fun `enum`(`value`: Output<List<Any>>) {
        this.`enum` = value
    }

    @JvmName("tbsoxkxerpaumdnd")
    public suspend fun `enum`(vararg values: Output<Any>) {
        this.`enum` = Output.all(values.asList())
    }

    /**
     * @param values If the data type is categorical, this provides the list of accepted categories.
     */
    @JvmName("vcdaovvlkdnyaqyg")
    public suspend fun `enum`(values: List<Output<Any>>) {
        this.`enum` = Output.all(values)
    }

    /**
     * @param value Additional format information for the data type.
     */
    @JvmName("ikoataflfpvvttyf")
    public suspend fun format(`value`: Output<Either<String, ColumnFormat>>) {
        this.format = value
    }

    /**
     * @param value Data type of the column.
     */
    @JvmName("jxvdkqjjpleegdvf")
    public suspend fun type(`value`: Output<Either<String, ColumnType>>) {
        this.type = value
    }

    /**
     * @param value Flag indicating if the type supports null values or not.
     */
    @JvmName("xnwxjikcmgqvunmx")
    public suspend fun xMsIsnullable(`value`: Output<Boolean>) {
        this.xMsIsnullable = value
    }

    /**
     * @param value Flag indicating whether the categories are treated as an ordered set or not, if this is a categorical column.
     */
    @JvmName("vpbcwhxkehtmhvap")
    public suspend fun xMsIsordered(`value`: Output<Boolean>) {
        this.xMsIsordered = value
    }

    /**
     * @param value If the data type is categorical, this provides the list of accepted categories.
     */
    @JvmName("dfwmwgimvnkyclgg")
    public suspend fun `enum`(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`enum` = mapped
    }

    /**
     * @param values If the data type is categorical, this provides the list of accepted categories.
     */
    @JvmName("jnegkhmoxcrfjpiv")
    public suspend fun `enum`(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`enum` = mapped
    }

    /**
     * @param value Additional format information for the data type.
     */
    @JvmName("ffkcegljwrtajtsu")
    public suspend fun format(`value`: Either<String, ColumnFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Additional format information for the data type.
     */
    @JvmName("ehdjhmvnftrynhup")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ColumnFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Additional format information for the data type.
     */
    @JvmName("yrxywirwgrhaasou")
    public fun format(`value`: ColumnFormat) {
        val toBeMapped = Either.ofRight<String, ColumnFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Data type of the column.
     */
    @JvmName("yfgsitchuomfimtu")
    public suspend fun type(`value`: Either<String, ColumnType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Data type of the column.
     */
    @JvmName("kbkxwsofumjnjfij")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ColumnType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Data type of the column.
     */
    @JvmName("oadrnnuwxnecwmjm")
    public fun type(`value`: ColumnType) {
        val toBeMapped = Either.ofRight<String, ColumnType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Flag indicating if the type supports null values or not.
     */
    @JvmName("voabijiggmqedfpa")
    public suspend fun xMsIsnullable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xMsIsnullable = mapped
    }

    /**
     * @param value Flag indicating whether the categories are treated as an ordered set or not, if this is a categorical column.
     */
    @JvmName("lpqmmawyutoffred")
    public suspend fun xMsIsordered(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xMsIsordered = mapped
    }

    internal fun build(): ColumnSpecificationArgs = ColumnSpecificationArgs(
        `enum` = `enum`,
        format = format,
        type = type ?: throw PulumiNullFieldException("type"),
        xMsIsnullable = xMsIsnullable,
        xMsIsordered = xMsIsordered,
    )
}
