@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.DiagnosticsConfigurationArgs.builder
import com.pulumi.azurenative.machinelearning.kotlin.enums.DiagnosticsLevel
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Diagnostics settings for an Azure ML web service.
 * @property expiry Specifies the date and time when the logging will cease. If null, diagnostic collection is not time limited.
 * @property level Specifies the verbosity of the diagnostic output. Valid values are: None - disables tracing; Error - collects only error (stderr) traces; All - collects all traces (stdout and stderr).
 */
public data class DiagnosticsConfigurationArgs(
    public val expiry: Output<String>? = null,
    public val level: Output<Either<String, DiagnosticsLevel>>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.DiagnosticsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.DiagnosticsConfigurationArgs =
        com.pulumi.azurenative.machinelearning.inputs.DiagnosticsConfigurationArgs.builder()
            .expiry(expiry?.applyValue({ args0 -> args0 }))
            .level(
                level.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DiagnosticsConfigurationArgs].
 */
@PulumiTagMarker
public class DiagnosticsConfigurationArgsBuilder internal constructor() {
    private var expiry: Output<String>? = null

    private var level: Output<Either<String, DiagnosticsLevel>>? = null

    /**
     * @param value Specifies the date and time when the logging will cease. If null, diagnostic collection is not time limited.
     */
    @JvmName("xqfjnewwjqqmjxkt")
    public suspend fun expiry(`value`: Output<String>) {
        this.expiry = value
    }

    /**
     * @param value Specifies the verbosity of the diagnostic output. Valid values are: None - disables tracing; Error - collects only error (stderr) traces; All - collects all traces (stdout and stderr).
     */
    @JvmName("uecksgcipnlahpsk")
    public suspend fun level(`value`: Output<Either<String, DiagnosticsLevel>>) {
        this.level = value
    }

    /**
     * @param value Specifies the date and time when the logging will cease. If null, diagnostic collection is not time limited.
     */
    @JvmName("jnpsxotqqjebhtqg")
    public suspend fun expiry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiry = mapped
    }

    /**
     * @param value Specifies the verbosity of the diagnostic output. Valid values are: None - disables tracing; Error - collects only error (stderr) traces; All - collects all traces (stdout and stderr).
     */
    @JvmName("ysgmikkdismxjuqx")
    public suspend fun level(`value`: Either<String, DiagnosticsLevel>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value Specifies the verbosity of the diagnostic output. Valid values are: None - disables tracing; Error - collects only error (stderr) traces; All - collects all traces (stdout and stderr).
     */
    @JvmName("lyximpuwqhiafljh")
    public fun level(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiagnosticsLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value Specifies the verbosity of the diagnostic output. Valid values are: None - disables tracing; Error - collects only error (stderr) traces; All - collects all traces (stdout and stderr).
     */
    @JvmName("qbodaqcisoyqubae")
    public fun level(`value`: DiagnosticsLevel) {
        val toBeMapped = Either.ofRight<String, DiagnosticsLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.level = mapped
    }

    internal fun build(): DiagnosticsConfigurationArgs = DiagnosticsConfigurationArgs(
        expiry = expiry,
        level = level ?: throw PulumiNullFieldException("level"),
    )
}
