@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.GetWebServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property region The region for which encrypted credential parameters are valid.
 * @property resourceGroupName Name of the resource group in which the web service is located.
 * @property webServiceName The name of the web service.
 */
public data class GetWebServicePlainArgs(
    public val region: String? = null,
    public val resourceGroupName: String,
    public val webServiceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.GetWebServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.GetWebServicePlainArgs =
        com.pulumi.azurenative.machinelearning.inputs.GetWebServicePlainArgs.builder()
            .region(region?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .webServiceName(webServiceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebServicePlainArgs].
 */
@PulumiTagMarker
public class GetWebServicePlainArgsBuilder internal constructor() {
    private var region: String? = null

    private var resourceGroupName: String? = null

    private var webServiceName: String? = null

    /**
     * @param value The region for which encrypted credential parameters are valid.
     */
    @JvmName("yfaooyrwdldlhifj")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.region = mapped
    }

    /**
     * @param value Name of the resource group in which the web service is located.
     */
    @JvmName("ieadiaftlloxhtdd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the web service.
     */
    @JvmName("xtcsemaekclyaopm")
    public suspend fun webServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.webServiceName = mapped
    }

    internal fun build(): GetWebServicePlainArgs = GetWebServicePlainArgs(
        region = region,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        webServiceName = webServiceName ?: throw PulumiNullFieldException("webServiceName"),
    )
}
