@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.GraphPackageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines the graph of modules making up the machine learning solution.
 * @property edges The list of edges making up the graph.
 * @property graphParameters The collection of global parameters for the graph, given as a global parameter name to GraphParameter map. Each parameter here has a 1:1 match with the global parameters values map declared at the WebServiceProperties level.
 * @property nodes The set of nodes making up the graph, provided as a nodeId to GraphNode map
 */
public data class GraphPackageArgs(
    public val edges: Output<List<GraphEdgeArgs>>? = null,
    public val graphParameters: Output<Map<String, GraphParameterArgs>>? = null,
    public val nodes: Output<Map<String, GraphNodeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.GraphPackageArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.GraphPackageArgs =
        com.pulumi.azurenative.machinelearning.inputs.GraphPackageArgs.builder()
            .edges(edges?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .graphParameters(
                graphParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .nodes(
                nodes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.let({ args0 ->
                                args0.toJava()
                            }),
                        )
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GraphPackageArgs].
 */
@PulumiTagMarker
public class GraphPackageArgsBuilder internal constructor() {
    private var edges: Output<List<GraphEdgeArgs>>? = null

    private var graphParameters: Output<Map<String, GraphParameterArgs>>? = null

    private var nodes: Output<Map<String, GraphNodeArgs>>? = null

    /**
     * @param value The list of edges making up the graph.
     */
    @JvmName("ykgovgxcrfwxakdi")
    public suspend fun edges(`value`: Output<List<GraphEdgeArgs>>) {
        this.edges = value
    }

    @JvmName("wcsimvobfejeyvav")
    public suspend fun edges(vararg values: Output<GraphEdgeArgs>) {
        this.edges = Output.all(values.asList())
    }

    /**
     * @param values The list of edges making up the graph.
     */
    @JvmName("lirgfbfvontlkwmn")
    public suspend fun edges(values: List<Output<GraphEdgeArgs>>) {
        this.edges = Output.all(values)
    }

    /**
     * @param value The collection of global parameters for the graph, given as a global parameter name to GraphParameter map. Each parameter here has a 1:1 match with the global parameters values map declared at the WebServiceProperties level.
     */
    @JvmName("mjxtimkboknfgaib")
    public suspend fun graphParameters(`value`: Output<Map<String, GraphParameterArgs>>) {
        this.graphParameters = value
    }

    /**
     * @param value The set of nodes making up the graph, provided as a nodeId to GraphNode map
     */
    @JvmName("ckvvhtgehgwkoyyd")
    public suspend fun nodes(`value`: Output<Map<String, GraphNodeArgs>>) {
        this.nodes = value
    }

    /**
     * @param value The list of edges making up the graph.
     */
    @JvmName("oinckfmunptvssec")
    public suspend fun edges(`value`: List<GraphEdgeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edges = mapped
    }

    /**
     * @param argument The list of edges making up the graph.
     */
    @JvmName("sbknkykecuttpxqp")
    public suspend fun edges(argument: List<suspend GraphEdgeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GraphEdgeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.edges = mapped
    }

    /**
     * @param argument The list of edges making up the graph.
     */
    @JvmName("dpiyuabdlyplfatc")
    public suspend fun edges(vararg argument: suspend GraphEdgeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GraphEdgeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.edges = mapped
    }

    /**
     * @param argument The list of edges making up the graph.
     */
    @JvmName("xyxvabmekajvlosj")
    public suspend fun edges(argument: suspend GraphEdgeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GraphEdgeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.edges = mapped
    }

    /**
     * @param values The list of edges making up the graph.
     */
    @JvmName("oetopggtgipxfevn")
    public suspend fun edges(vararg values: GraphEdgeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.edges = mapped
    }

    /**
     * @param value The collection of global parameters for the graph, given as a global parameter name to GraphParameter map. Each parameter here has a 1:1 match with the global parameters values map declared at the WebServiceProperties level.
     */
    @JvmName("bqoojuufymsmtwof")
    public suspend fun graphParameters(`value`: Map<String, GraphParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.graphParameters = mapped
    }

    /**
     * @param argument The collection of global parameters for the graph, given as a global parameter name to GraphParameter map. Each parameter here has a 1:1 match with the global parameters values map declared at the WebServiceProperties level.
     */
    @JvmName("xjjabpsksjavxduf")
    public suspend fun graphParameters(
        vararg
        argument: Pair<String, suspend GraphParameterArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                GraphParameterArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.graphParameters = mapped
    }

    /**
     * @param values The collection of global parameters for the graph, given as a global parameter name to GraphParameter map. Each parameter here has a 1:1 match with the global parameters values map declared at the WebServiceProperties level.
     */
    @JvmName("atatuoeosnmdsyxn")
    public fun graphParameters(vararg values: Pair<String, GraphParameterArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.graphParameters = mapped
    }

    /**
     * @param value The set of nodes making up the graph, provided as a nodeId to GraphNode map
     */
    @JvmName("udxcvhpkmkmpbmed")
    public suspend fun nodes(`value`: Map<String, GraphNodeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodes = mapped
    }

    /**
     * @param argument The set of nodes making up the graph, provided as a nodeId to GraphNode map
     */
    @JvmName("rwkkuumschwpfbxr")
    public suspend fun nodes(vararg argument: Pair<String, suspend GraphNodeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                GraphNodeArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.nodes = mapped
    }

    /**
     * @param values The set of nodes making up the graph, provided as a nodeId to GraphNode map
     */
    @JvmName("nkuhjlsujvyyrpap")
    public fun nodes(vararg values: Pair<String, GraphNodeArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodes = mapped
    }

    internal fun build(): GraphPackageArgs = GraphPackageArgs(
        edges = edges,
        graphParameters = graphParameters,
        nodes = nodes,
    )
}
