@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.GraphParameterArgs.builder
import com.pulumi.azurenative.machinelearning.kotlin.enums.ParameterType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a global parameter in the graph.
 * @property description Description of this graph parameter.
 * @property links Association links for this parameter to nodes in the graph.
 * @property type Graph parameter's type.
 */
public data class GraphParameterArgs(
    public val description: Output<String>? = null,
    public val links: Output<List<GraphParameterLinkArgs>>,
    public val type: Output<Either<String, ParameterType>>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.GraphParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.GraphParameterArgs =
        com.pulumi.azurenative.machinelearning.inputs.GraphParameterArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .links(links.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GraphParameterArgs].
 */
@PulumiTagMarker
public class GraphParameterArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var links: Output<List<GraphParameterLinkArgs>>? = null

    private var type: Output<Either<String, ParameterType>>? = null

    /**
     * @param value Description of this graph parameter.
     */
    @JvmName("jnynsxnbjmwvwgki")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Association links for this parameter to nodes in the graph.
     */
    @JvmName("nwtsybhsmeggsmfe")
    public suspend fun links(`value`: Output<List<GraphParameterLinkArgs>>) {
        this.links = value
    }

    @JvmName("qefebdwkjjarcujq")
    public suspend fun links(vararg values: Output<GraphParameterLinkArgs>) {
        this.links = Output.all(values.asList())
    }

    /**
     * @param values Association links for this parameter to nodes in the graph.
     */
    @JvmName("hisngqtktktksbea")
    public suspend fun links(values: List<Output<GraphParameterLinkArgs>>) {
        this.links = Output.all(values)
    }

    /**
     * @param value Graph parameter's type.
     */
    @JvmName("qwcxatoiytbdkhre")
    public suspend fun type(`value`: Output<Either<String, ParameterType>>) {
        this.type = value
    }

    /**
     * @param value Description of this graph parameter.
     */
    @JvmName("rissmyuodmrdycme")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Association links for this parameter to nodes in the graph.
     */
    @JvmName("sipoxsywwjtainjy")
    public suspend fun links(`value`: List<GraphParameterLinkArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.links = mapped
    }

    /**
     * @param argument Association links for this parameter to nodes in the graph.
     */
    @JvmName("nqqhmxrllludgkvi")
    public suspend fun links(argument: List<suspend GraphParameterLinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GraphParameterLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param argument Association links for this parameter to nodes in the graph.
     */
    @JvmName("cfojnlydaylfuyeb")
    public suspend fun links(vararg argument: suspend GraphParameterLinkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GraphParameterLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param argument Association links for this parameter to nodes in the graph.
     */
    @JvmName("qddohkxkdykmgfgc")
    public suspend fun links(argument: suspend GraphParameterLinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GraphParameterLinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param values Association links for this parameter to nodes in the graph.
     */
    @JvmName("qxgiqikwghjprrxx")
    public suspend fun links(vararg values: GraphParameterLinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.links = mapped
    }

    /**
     * @param value Graph parameter's type.
     */
    @JvmName("duhwsrfefvfjlfuu")
    public suspend fun type(`value`: Either<String, ParameterType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Graph parameter's type.
     */
    @JvmName("xqvcclholqfdcaoq")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Graph parameter's type.
     */
    @JvmName("mcbdkirmnkhoorcn")
    public fun type(`value`: ParameterType) {
        val toBeMapped = Either.ofRight<String, ParameterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): GraphParameterArgs = GraphParameterArgs(
        description = description,
        links = links ?: throw PulumiNullFieldException("links"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
