@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.InputPortArgs.builder
import com.pulumi.azurenative.machinelearning.kotlin.enums.InputPortType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Asset input port
 * @property type Port data type.
 */
public data class InputPortArgs(
    public val type: Output<Either<String, InputPortType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.InputPortArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.InputPortArgs =
        com.pulumi.azurenative.machinelearning.inputs.InputPortArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [InputPortArgs].
 */
@PulumiTagMarker
public class InputPortArgsBuilder internal constructor() {
    private var type: Output<Either<String, InputPortType>>? = null

    /**
     * @param value Port data type.
     */
    @JvmName("xexhkumdtkebjgkp")
    public suspend fun type(`value`: Output<Either<String, InputPortType>>) {
        this.type = value
    }

    /**
     * @param value Port data type.
     */
    @JvmName("gwxmmiyytxyqrtxx")
    public suspend fun type(`value`: Either<String, InputPortType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Port data type.
     */
    @JvmName("hmfmuglwpoyyykbx")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InputPortType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Port data type.
     */
    @JvmName("sximjyyiehaykklj")
    public fun type(`value`: InputPortType) {
        val toBeMapped = Either.ofRight<String, InputPortType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): InputPortArgs = InputPortArgs(
        type = type,
    )
}
