@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.ModuleAssetParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Parameter definition for a module asset.
 * @property modeValuesInfo Definitions for nested interface parameters if this is a complex module parameter.
 * @property name Parameter name.
 * @property parameterType Parameter type.
 */
public data class ModuleAssetParameterArgs(
    public val modeValuesInfo: Output<Map<String, ModeValueInfoArgs>>? = null,
    public val name: Output<String>? = null,
    public val parameterType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.ModuleAssetParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.ModuleAssetParameterArgs =
        com.pulumi.azurenative.machinelearning.inputs.ModuleAssetParameterArgs.builder()
            .modeValuesInfo(
                modeValuesInfo?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .parameterType(parameterType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ModuleAssetParameterArgs].
 */
@PulumiTagMarker
public class ModuleAssetParameterArgsBuilder internal constructor() {
    private var modeValuesInfo: Output<Map<String, ModeValueInfoArgs>>? = null

    private var name: Output<String>? = null

    private var parameterType: Output<String>? = null

    /**
     * @param value Definitions for nested interface parameters if this is a complex module parameter.
     */
    @JvmName("nsjgmvsjrlprttbb")
    public suspend fun modeValuesInfo(`value`: Output<Map<String, ModeValueInfoArgs>>) {
        this.modeValuesInfo = value
    }

    /**
     * @param value Parameter name.
     */
    @JvmName("llwbhgoxpxmquhjd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Parameter type.
     */
    @JvmName("ngbgmsdlpvkgmxev")
    public suspend fun parameterType(`value`: Output<String>) {
        this.parameterType = value
    }

    /**
     * @param value Definitions for nested interface parameters if this is a complex module parameter.
     */
    @JvmName("oxgnghqspupdytxc")
    public suspend fun modeValuesInfo(`value`: Map<String, ModeValueInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modeValuesInfo = mapped
    }

    /**
     * @param argument Definitions for nested interface parameters if this is a complex module parameter.
     */
    @JvmName("avlfncxmvfcnekbd")
    public suspend fun modeValuesInfo(
        vararg
        argument: Pair<String, suspend ModeValueInfoArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ModeValueInfoArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.modeValuesInfo = mapped
    }

    /**
     * @param values Definitions for nested interface parameters if this is a complex module parameter.
     */
    @JvmName("fuugqshqmfguvoit")
    public fun modeValuesInfo(vararg values: Pair<String, ModeValueInfoArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.modeValuesInfo = mapped
    }

    /**
     * @param value Parameter name.
     */
    @JvmName("asxqhiwgcljwhoqu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Parameter type.
     */
    @JvmName("kpnfrwssglhbybvc")
    public suspend fun parameterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterType = mapped
    }

    internal fun build(): ModuleAssetParameterArgs = ModuleAssetParameterArgs(
        modeValuesInfo = modeValuesInfo,
        name = name,
        parameterType = parameterType,
    )
}
