@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.ResourceSkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The SKU of a resource.
 * @property capacity The scale-out capacity of the resource. 1 is 1x, 2 is 2x, etc. This impacts the quantities and cost of any commitment plan resource.
 * @property name The SKU name. Along with tier, uniquely identifies the SKU.
 * @property tier The SKU tier. Along with name, uniquely identifies the SKU.
 */
public data class ResourceSkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.ResourceSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.ResourceSkuArgs =
        com.pulumi.azurenative.machinelearning.inputs.ResourceSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceSkuArgs].
 */
@PulumiTagMarker
public class ResourceSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value The scale-out capacity of the resource. 1 is 1x, 2 is 2x, etc. This impacts the quantities and cost of any commitment plan resource.
     */
    @JvmName("odxaiyxojmfildsy")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The SKU name. Along with tier, uniquely identifies the SKU.
     */
    @JvmName("wtluvxrwsfrntcfs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The SKU tier. Along with name, uniquely identifies the SKU.
     */
    @JvmName("pllytcmxlwxrolcf")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The scale-out capacity of the resource. 1 is 1x, 2 is 2x, etc. This impacts the quantities and cost of any commitment plan resource.
     */
    @JvmName("vbtoqhwqmecngxru")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The SKU name. Along with tier, uniquely identifies the SKU.
     */
    @JvmName("lebhyjaxgyaemaav")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The SKU tier. Along with name, uniquely identifies the SKU.
     */
    @JvmName("eerkdlnmbhgqwvhh")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): ResourceSkuArgs = ResourceSkuArgs(
        capacity = capacity,
        name = name,
        tier = tier,
    )
}
