@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.StorageAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Access information for a storage account.
 * @property key Specifies the key used to access the storage account.
 * @property name Specifies the name of the storage account.
 */
public data class StorageAccountArgs(
    public val key: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.StorageAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.StorageAccountArgs =
        com.pulumi.azurenative.machinelearning.inputs.StorageAccountArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageAccountArgs].
 */
@PulumiTagMarker
public class StorageAccountArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Specifies the key used to access the storage account.
     */
    @JvmName("jvipstcinfoymypf")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Specifies the name of the storage account.
     */
    @JvmName("vhfyqkimfobegqec")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the key used to access the storage account.
     */
    @JvmName("upychtjpcflhncbv")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Specifies the name of the storage account.
     */
    @JvmName("drdrsfxvscthpjpr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): StorageAccountArgs = StorageAccountArgs(
        key = key,
        name = name,
    )
}
