@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Association link for a graph global parameter to a node in the graph.
 * @property nodeId The graph node's identifier
 * @property parameterKey The identifier of the node parameter that the global parameter maps to.
 */
public data class GraphParameterLinkResponse(
    public val nodeId: String,
    public val parameterKey: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.GraphParameterLinkResponse):
            GraphParameterLinkResponse = GraphParameterLinkResponse(
            nodeId = javaType.nodeId(),
            parameterKey = javaType.parameterKey(),
        )
    }
}
