@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about the machine learning workspace containing the experiment that is source for the web service.
 * @property id Specifies the workspace ID of the machine learning workspace associated with the web service
 */
public data class MachineLearningWorkspaceResponse(
    public val id: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.MachineLearningWorkspaceResponse):
            MachineLearningWorkspaceResponse = MachineLearningWorkspaceResponse(
            id = javaType.id(),
        )
    }
}
