@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The swagger 2.0 schema describing the service's inputs or outputs. See Swagger specification: http://swagger.io/specification/
 * @property description The description of the Swagger schema.
 * @property properties Specifies a collection that contains the column schema for each input or output of the web service. For more information, see the Swagger specification.
 * @property title The title of your Swagger schema.
 * @property type The type of the entity described in swagger. Always 'object'.
 */
public data class ServiceInputOutputSpecificationResponse(
    public val description: String? = null,
    public val properties: Map<String, TableSpecificationResponse>,
    public val title: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.ServiceInputOutputSpecificationResponse):
            ServiceInputOutputSpecificationResponse = ServiceInputOutputSpecificationResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearning.kotlin.outputs.TableSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
