@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Access information for a storage account.
 * @property key Specifies the key used to access the storage account.
 * @property name Specifies the name of the storage account.
 */
public data class StorageAccountResponse(
    public val key: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.StorageAccountResponse):
            StorageAccountResponse = StorageAccountResponse(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
