@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin

import com.pulumi.azurenative.machinelearningcompute.OperationalizationClusterArgs.builder
import com.pulumi.azurenative.machinelearningcompute.kotlin.enums.ClusterType
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.AcsClusterPropertiesArgs
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.AcsClusterPropertiesArgsBuilder
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.AppInsightsPropertiesArgs
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.AppInsightsPropertiesArgsBuilder
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.ContainerRegistryPropertiesArgs
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.ContainerRegistryPropertiesArgsBuilder
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.GlobalServiceConfigurationArgs
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.GlobalServiceConfigurationArgsBuilder
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.StorageAccountPropertiesArgs
import com.pulumi.azurenative.machinelearningcompute.kotlin.inputs.StorageAccountPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Instance of an Azure ML Operationalization Cluster resource.
 * Azure REST API version: 2017-08-01-preview. Prior API version in Azure Native 1.x: 2017-08-01-preview.
 * Other available API versions: 2017-06-01-preview.
 * ## Example Usage
 * ### PUT Operationalization Cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var operationalizationCluster = new AzureNative.MachineLearningCompute.OperationalizationCluster("operationalizationCluster", new()
 *     {
 *         ClusterName = "myCluster",
 *         ClusterType = "ACS",
 *         ContainerService = new AzureNative.MachineLearningCompute.Inputs.AcsClusterPropertiesArgs
 *         {
 *             OrchestratorProperties = new AzureNative.MachineLearningCompute.Inputs.KubernetesClusterPropertiesArgs
 *             {
 *                 ServicePrincipal = new AzureNative.MachineLearningCompute.Inputs.ServicePrincipalPropertiesArgs
 *                 {
 *                     ClientId = "abcdefghijklmnopqrt",
 *                     Secret = "<secret>",
 *                 },
 *             },
 *             OrchestratorType = "Kubernetes",
 *         },
 *         Description = "My Operationalization Cluster",
 *         GlobalServiceConfiguration = new AzureNative.MachineLearningCompute.Inputs.GlobalServiceConfigurationArgs
 *         {
 *             Ssl = new AzureNative.MachineLearningCompute.Inputs.SslConfigurationArgs
 *             {
 *                 Cert = "afjdklq2131casfakld=",
 *                 Cname = "foo.bar.com",
 *                 Key = "flksdafkldsajf=",
 *                 Status = "Enabled",
 *             },
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "key1", "alpha" },
 *             { "key2", "beta" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningcompute.NewOperationalizationCluster(ctx, "operationalizationCluster", &machinelearningcompute.OperationalizationClusterArgs{
 * ClusterName: pulumi.String("myCluster"),
 * ClusterType: pulumi.String("ACS"),
 * ContainerService: machinelearningcompute.AcsClusterPropertiesResponse{
 * OrchestratorProperties: interface{}{
 * ServicePrincipal: &machinelearningcompute.ServicePrincipalPropertiesArgs{
 * ClientId: pulumi.String("abcdefghijklmnopqrt"),
 * Secret: pulumi.String("<secret>"),
 * },
 * },
 * OrchestratorType: pulumi.String("Kubernetes"),
 * },
 * Description: pulumi.String("My Operationalization Cluster"),
 * GlobalServiceConfiguration: machinelearningcompute.GlobalServiceConfigurationResponse{
 * Ssl: &machinelearningcompute.SslConfigurationArgs{
 * Cert: pulumi.String("afjdklq2131casfakld="),
 * Cname: pulumi.String("foo.bar.com"),
 * Key: pulumi.String("flksdafkldsajf="),
 * Status: pulumi.String("Enabled"),
 * },
 * },
 * Location: pulumi.String("West US"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("alpha"),
 * "key2": pulumi.String("beta"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningcompute.OperationalizationCluster;
 * import com.pulumi.azurenative.machinelearningcompute.OperationalizationClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var operationalizationCluster = new OperationalizationCluster("operationalizationCluster", OperationalizationClusterArgs.builder()
 *             .clusterName("myCluster")
 *             .clusterType("ACS")
 *             .containerService(Map.ofEntries(
 *                 Map.entry("orchestratorProperties", Map.of("servicePrincipal", Map.ofEntries(
 *                     Map.entry("clientId", "abcdefghijklmnopqrt"),
 *                     Map.entry("secret", "<secret>")
 *                 ))),
 *                 Map.entry("orchestratorType", "Kubernetes")
 *             ))
 *             .description("My Operationalization Cluster")
 *             .globalServiceConfiguration(Map.of("ssl", Map.ofEntries(
 *                 Map.entry("cert", "afjdklq2131casfakld="),
 *                 Map.entry("cname", "foo.bar.com"),
 *                 Map.entry("key", "flksdafkldsajf="),
 *                 Map.entry("status", "Enabled")
 *             )))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "alpha"),
 *                 Map.entry("key2", "beta")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningcompute:OperationalizationCluster MyCluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}
 * ```
 * @property appInsights AppInsights configuration.
 * @property clusterName The name of the cluster.
 * @property clusterType The cluster type.
 * @property containerRegistry Container Registry properties.
 * @property containerService Parameters for the Azure Container Service cluster.
 * @property description The description of the cluster.
 * @property globalServiceConfiguration Contains global configuration for the web services in the cluster.
 * @property location Specifies the location of the resource.
 * @property resourceGroupName Name of the resource group in which the cluster is located.
 * @property storageAccount Storage Account properties.
 * @property tags Contains resource tags defined as key/value pairs.
 */
public data class OperationalizationClusterArgs(
    public val appInsights: Output<AppInsightsPropertiesArgs>? = null,
    public val clusterName: Output<String>? = null,
    public val clusterType: Output<Either<String, ClusterType>>? = null,
    public val containerRegistry: Output<ContainerRegistryPropertiesArgs>? = null,
    public val containerService: Output<AcsClusterPropertiesArgs>? = null,
    public val description: Output<String>? = null,
    public val globalServiceConfiguration: Output<GlobalServiceConfigurationArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccount: Output<StorageAccountPropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.OperationalizationClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningcompute.OperationalizationClusterArgs =
        com.pulumi.azurenative.machinelearningcompute.OperationalizationClusterArgs.builder()
            .appInsights(appInsights?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .clusterType(
                clusterType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .containerRegistry(containerRegistry?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .containerService(containerService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .globalServiceConfiguration(
                globalServiceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccount(storageAccount?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [OperationalizationClusterArgs].
 */
@PulumiTagMarker
public class OperationalizationClusterArgsBuilder internal constructor() {
    private var appInsights: Output<AppInsightsPropertiesArgs>? = null

    private var clusterName: Output<String>? = null

    private var clusterType: Output<Either<String, ClusterType>>? = null

    private var containerRegistry: Output<ContainerRegistryPropertiesArgs>? = null

    private var containerService: Output<AcsClusterPropertiesArgs>? = null

    private var description: Output<String>? = null

    private var globalServiceConfiguration: Output<GlobalServiceConfigurationArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccount: Output<StorageAccountPropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value AppInsights configuration.
     */
    @JvmName("kvgofmuqmpdguyxr")
    public suspend fun appInsights(`value`: Output<AppInsightsPropertiesArgs>) {
        this.appInsights = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("myhfsxqglvmemqip")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The cluster type.
     */
    @JvmName("lwodiumbcvlvbihh")
    public suspend fun clusterType(`value`: Output<Either<String, ClusterType>>) {
        this.clusterType = value
    }

    /**
     * @param value Container Registry properties.
     */
    @JvmName("tnfnjmvodluippix")
    public suspend fun containerRegistry(`value`: Output<ContainerRegistryPropertiesArgs>) {
        this.containerRegistry = value
    }

    /**
     * @param value Parameters for the Azure Container Service cluster.
     */
    @JvmName("rjvbhrhoryqmufjn")
    public suspend fun containerService(`value`: Output<AcsClusterPropertiesArgs>) {
        this.containerService = value
    }

    /**
     * @param value The description of the cluster.
     */
    @JvmName("jhmewjqxamgounsk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Contains global configuration for the web services in the cluster.
     */
    @JvmName("lqdpeuitgcyegkgn")
    public suspend fun globalServiceConfiguration(`value`: Output<GlobalServiceConfigurationArgs>) {
        this.globalServiceConfiguration = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("efudhcvdcalcrmau")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the resource group in which the cluster is located.
     */
    @JvmName("dwepqtnwnmylysut")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Storage Account properties.
     */
    @JvmName("dfbjubsqkbhxaatb")
    public suspend fun storageAccount(`value`: Output<StorageAccountPropertiesArgs>) {
        this.storageAccount = value
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("hdxhnjbmltmgdaov")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value AppInsights configuration.
     */
    @JvmName("jkotpelghbwkvcsb")
    public suspend fun appInsights(`value`: AppInsightsPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appInsights = mapped
    }

    /**
     * @param argument AppInsights configuration.
     */
    @JvmName("syhmksefusxybdfw")
    public suspend fun appInsights(argument: suspend AppInsightsPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AppInsightsPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.appInsights = mapped
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("dqcalxjyggnkyvpn")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The cluster type.
     */
    @JvmName("ymdiqxsaxnowalbk")
    public suspend fun clusterType(`value`: Either<String, ClusterType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterType = mapped
    }

    /**
     * @param value The cluster type.
     */
    @JvmName("phfywkvfllphwanu")
    public fun clusterType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClusterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterType = mapped
    }

    /**
     * @param value The cluster type.
     */
    @JvmName("pykvykkbawikjxwk")
    public fun clusterType(`value`: ClusterType) {
        val toBeMapped = Either.ofRight<String, ClusterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterType = mapped
    }

    /**
     * @param value Container Registry properties.
     */
    @JvmName("bkuikhpyfyvglwyu")
    public suspend fun containerRegistry(`value`: ContainerRegistryPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRegistry = mapped
    }

    /**
     * @param argument Container Registry properties.
     */
    @JvmName("ghemmijovdlcivnc")
    public suspend
    fun containerRegistry(argument: suspend ContainerRegistryPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerRegistryPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerRegistry = mapped
    }

    /**
     * @param value Parameters for the Azure Container Service cluster.
     */
    @JvmName("lsxjfvkgduxptrqc")
    public suspend fun containerService(`value`: AcsClusterPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerService = mapped
    }

    /**
     * @param argument Parameters for the Azure Container Service cluster.
     */
    @JvmName("uhgponcusivsfwyu")
    public suspend
    fun containerService(argument: suspend AcsClusterPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AcsClusterPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerService = mapped
    }

    /**
     * @param value The description of the cluster.
     */
    @JvmName("ebgavubamiknakrm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Contains global configuration for the web services in the cluster.
     */
    @JvmName("qswbrxaecbxlflen")
    public suspend fun globalServiceConfiguration(`value`: GlobalServiceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalServiceConfiguration = mapped
    }

    /**
     * @param argument Contains global configuration for the web services in the cluster.
     */
    @JvmName("hvcnmtgflriogxyv")
    public suspend
    fun globalServiceConfiguration(argument: suspend GlobalServiceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = GlobalServiceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.globalServiceConfiguration = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("upcmlvmmixmtjlxt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the resource group in which the cluster is located.
     */
    @JvmName("cuqhvnombypnghan")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Storage Account properties.
     */
    @JvmName("mflnsqwwhsfbixhe")
    public suspend fun storageAccount(`value`: StorageAccountPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccount = mapped
    }

    /**
     * @param argument Storage Account properties.
     */
    @JvmName("iuoofxlusvwhphho")
    public suspend
    fun storageAccount(argument: suspend StorageAccountPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = StorageAccountPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageAccount = mapped
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("pjxooenrbmagmprt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Contains resource tags defined as key/value pairs.
     */
    @JvmName("ofdgusamogtturwb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): OperationalizationClusterArgs = OperationalizationClusterArgs(
        appInsights = appInsights,
        clusterName = clusterName,
        clusterType = clusterType,
        containerRegistry = containerRegistry,
        containerService = containerService,
        description = description,
        globalServiceConfiguration = globalServiceConfiguration,
        location = location,
        resourceGroupName = resourceGroupName,
        storageAccount = storageAccount,
        tags = tags,
    )
}
