@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The Azure VM size of the agent VM nodes. This cannot be changed once the cluster is created. This list is non exhaustive; refer to https://docs.microsoft.com/en-us/azure/virtual-machines/windows/sizes for the possible VM sizes.
 */
public enum class AgentVMSizeTypes(
    public val javaValue: com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes> {
    Standard_A0(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_A0),
    Standard_A1(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_A1),
    Standard_A2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_A2),
    Standard_A3(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_A3),
    Standard_A4(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_A4),
    Standard_A5(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_A5),
    Standard_A6(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_A6),
    Standard_A7(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_A7),
    Standard_A8(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_A8),
    Standard_A9(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_A9),
    Standard_A10(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_A10),
    Standard_A11(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_A11),
    Standard_D1(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D1),
    Standard_D2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D2),
    Standard_D3(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D3),
    Standard_D4(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D4),
    Standard_D11(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D11),
    Standard_D12(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D12),
    Standard_D13(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D13),
    Standard_D14(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D14),
    Standard_D1_v2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D1_v2),
    Standard_D2_v2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D2_v2),
    Standard_D3_v2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D3_v2),
    Standard_D4_v2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D4_v2),
    Standard_D5_v2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D5_v2),
    Standard_D11_v2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D11_v2),
    Standard_D12_v2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D12_v2),
    Standard_D13_v2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D13_v2),
    Standard_D14_v2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_D14_v2),
    Standard_G1(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_G1),
    Standard_G2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_G2),
    Standard_G3(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_G3),
    Standard_G4(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_G4),
    Standard_G5(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_G5),
    Standard_DS1(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_DS1),
    Standard_DS2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_DS2),
    Standard_DS3(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_DS3),
    Standard_DS4(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_DS4),
    Standard_DS11(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_DS11),
    Standard_DS12(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_DS12),
    Standard_DS13(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_DS13),
    Standard_DS14(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_DS14),
    Standard_GS1(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_GS1),
    Standard_GS2(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_GS2),
    Standard_GS3(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_GS3),
    Standard_GS4(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_GS4),
    Standard_GS5(com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes.Standard_GS5),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.enums.AgentVMSizeTypes):
            AgentVMSizeTypes = AgentVMSizeTypes.values().first { it.javaValue == javaType }
    }
}
