@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.inputs

import com.pulumi.azurenative.machinelearningcompute.inputs.AutoScaleConfigurationArgs.builder
import com.pulumi.azurenative.machinelearningcompute.kotlin.enums.Status
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AutoScale configuration properties.
 * @property maxReplicas The maximum number of replicas for each service.
 * @property minReplicas The minimum number of replicas for each service.
 * @property refreshPeriodInSeconds Refresh period in seconds.
 * @property status If auto-scale is enabled for all services. Each service can turn it off individually.
 * @property targetUtilization The target utilization.
 */
public data class AutoScaleConfigurationArgs(
    public val maxReplicas: Output<Int>? = null,
    public val minReplicas: Output<Int>? = null,
    public val refreshPeriodInSeconds: Output<Int>? = null,
    public val status: Output<Either<String, Status>>? = null,
    public val targetUtilization: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.inputs.AutoScaleConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningcompute.inputs.AutoScaleConfigurationArgs =
        com.pulumi.azurenative.machinelearningcompute.inputs.AutoScaleConfigurationArgs.builder()
            .maxReplicas(maxReplicas?.applyValue({ args0 -> args0 }))
            .minReplicas(minReplicas?.applyValue({ args0 -> args0 }))
            .refreshPeriodInSeconds(refreshPeriodInSeconds?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetUtilization(targetUtilization?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoScaleConfigurationArgs].
 */
@PulumiTagMarker
public class AutoScaleConfigurationArgsBuilder internal constructor() {
    private var maxReplicas: Output<Int>? = null

    private var minReplicas: Output<Int>? = null

    private var refreshPeriodInSeconds: Output<Int>? = null

    private var status: Output<Either<String, Status>>? = null

    private var targetUtilization: Output<Double>? = null

    /**
     * @param value The maximum number of replicas for each service.
     */
    @JvmName("kjrbekayxdtgyefi")
    public suspend fun maxReplicas(`value`: Output<Int>) {
        this.maxReplicas = value
    }

    /**
     * @param value The minimum number of replicas for each service.
     */
    @JvmName("thucyjembuvbxibv")
    public suspend fun minReplicas(`value`: Output<Int>) {
        this.minReplicas = value
    }

    /**
     * @param value Refresh period in seconds.
     */
    @JvmName("bhodnvajhjtvmgat")
    public suspend fun refreshPeriodInSeconds(`value`: Output<Int>) {
        this.refreshPeriodInSeconds = value
    }

    /**
     * @param value If auto-scale is enabled for all services. Each service can turn it off individually.
     */
    @JvmName("saccffykgehwdume")
    public suspend fun status(`value`: Output<Either<String, Status>>) {
        this.status = value
    }

    /**
     * @param value The target utilization.
     */
    @JvmName("iviwlqfgmrkewkyt")
    public suspend fun targetUtilization(`value`: Output<Double>) {
        this.targetUtilization = value
    }

    /**
     * @param value The maximum number of replicas for each service.
     */
    @JvmName("hcpkuvqdpctxflyw")
    public suspend fun maxReplicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxReplicas = mapped
    }

    /**
     * @param value The minimum number of replicas for each service.
     */
    @JvmName("nqrawcfeodxgwbmh")
    public suspend fun minReplicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minReplicas = mapped
    }

    /**
     * @param value Refresh period in seconds.
     */
    @JvmName("wquawjiqwdxifqth")
    public suspend fun refreshPeriodInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshPeriodInSeconds = mapped
    }

    /**
     * @param value If auto-scale is enabled for all services. Each service can turn it off individually.
     */
    @JvmName("dilytnvmmlwarcqo")
    public suspend fun status(`value`: Either<String, Status>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value If auto-scale is enabled for all services. Each service can turn it off individually.
     */
    @JvmName("uahodsradqvywsxi")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value If auto-scale is enabled for all services. Each service can turn it off individually.
     */
    @JvmName("wevkduxoehklxbha")
    public fun status(`value`: Status) {
        val toBeMapped = Either.ofRight<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The target utilization.
     */
    @JvmName("plqqhfsrgodfifil")
    public suspend fun targetUtilization(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetUtilization = mapped
    }

    internal fun build(): AutoScaleConfigurationArgs = AutoScaleConfigurationArgs(
        maxReplicas = maxReplicas,
        minReplicas = minReplicas,
        refreshPeriodInSeconds = refreshPeriodInSeconds,
        status = status,
        targetUtilization = targetUtilization,
    )
}
