@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.inputs

import com.pulumi.azurenative.machinelearningcompute.inputs.ContainerRegistryPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of Azure Container Registry.
 * @property resourceId ARM resource ID of the Azure Container Registry used to store Docker images for web services in the cluster. If not provided one will be created. This cannot be changed once the cluster is created.
 */
public data class ContainerRegistryPropertiesArgs(
    public val resourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.inputs.ContainerRegistryPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningcompute.inputs.ContainerRegistryPropertiesArgs =
        com.pulumi.azurenative.machinelearningcompute.inputs.ContainerRegistryPropertiesArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerRegistryPropertiesArgs].
 */
@PulumiTagMarker
public class ContainerRegistryPropertiesArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    /**
     * @param value ARM resource ID of the Azure Container Registry used to store Docker images for web services in the cluster. If not provided one will be created. This cannot be changed once the cluster is created.
     */
    @JvmName("osumwayjmelwvenw")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value ARM resource ID of the Azure Container Registry used to store Docker images for web services in the cluster. If not provided one will be created. This cannot be changed once the cluster is created.
     */
    @JvmName("doenwpsvupirouli")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): ContainerRegistryPropertiesArgs = ContainerRegistryPropertiesArgs(
        resourceId = resourceId,
    )
}
