@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.inputs

import com.pulumi.azurenative.machinelearningcompute.inputs.GlobalServiceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Global configuration for services in the cluster.
 * @property autoScale The auto-scale configuration
 * @property etag The configuration ETag for updates.
 * @property serviceAuth Optional global authorization keys for all user services deployed in cluster. These are used if the service does not have auth keys.
 * @property ssl The SSL configuration properties
 */
public data class GlobalServiceConfigurationArgs(
    public val autoScale: Output<AutoScaleConfigurationArgs>? = null,
    public val etag: Output<String>? = null,
    public val serviceAuth: Output<ServiceAuthConfigurationArgs>? = null,
    public val ssl: Output<SslConfigurationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.inputs.GlobalServiceConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningcompute.inputs.GlobalServiceConfigurationArgs =
        com.pulumi.azurenative.machinelearningcompute.inputs.GlobalServiceConfigurationArgs.builder()
            .autoScale(autoScale?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .serviceAuth(serviceAuth?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ssl(ssl?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GlobalServiceConfigurationArgs].
 */
@PulumiTagMarker
public class GlobalServiceConfigurationArgsBuilder internal constructor() {
    private var autoScale: Output<AutoScaleConfigurationArgs>? = null

    private var etag: Output<String>? = null

    private var serviceAuth: Output<ServiceAuthConfigurationArgs>? = null

    private var ssl: Output<SslConfigurationArgs>? = null

    /**
     * @param value The auto-scale configuration
     */
    @JvmName("khsctxokfebsfgiw")
    public suspend fun autoScale(`value`: Output<AutoScaleConfigurationArgs>) {
        this.autoScale = value
    }

    /**
     * @param value The configuration ETag for updates.
     */
    @JvmName("vtqljxnlefjxpdul")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Optional global authorization keys for all user services deployed in cluster. These are used if the service does not have auth keys.
     */
    @JvmName("fhqnwodfkjseqnsp")
    public suspend fun serviceAuth(`value`: Output<ServiceAuthConfigurationArgs>) {
        this.serviceAuth = value
    }

    /**
     * @param value The SSL configuration properties
     */
    @JvmName("iqoiygimsnknjqwr")
    public suspend fun ssl(`value`: Output<SslConfigurationArgs>) {
        this.ssl = value
    }

    /**
     * @param value The auto-scale configuration
     */
    @JvmName("xiqchapwrcanuixe")
    public suspend fun autoScale(`value`: AutoScaleConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScale = mapped
    }

    /**
     * @param argument The auto-scale configuration
     */
    @JvmName("eodgnfcmbcxatgvc")
    public suspend fun autoScale(argument: suspend AutoScaleConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AutoScaleConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoScale = mapped
    }

    /**
     * @param value The configuration ETag for updates.
     */
    @JvmName("hwjfrliqyufklgxi")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Optional global authorization keys for all user services deployed in cluster. These are used if the service does not have auth keys.
     */
    @JvmName("ytbticvvtfeppgfj")
    public suspend fun serviceAuth(`value`: ServiceAuthConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAuth = mapped
    }

    /**
     * @param argument Optional global authorization keys for all user services deployed in cluster. These are used if the service does not have auth keys.
     */
    @JvmName("xiojectqdcrkangc")
    public suspend fun serviceAuth(argument: suspend ServiceAuthConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceAuthConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceAuth = mapped
    }

    /**
     * @param value The SSL configuration properties
     */
    @JvmName("irwpvlkymgtscflt")
    public suspend fun ssl(`value`: SslConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssl = mapped
    }

    /**
     * @param argument The SSL configuration properties
     */
    @JvmName("lwxvujrjmcpenmre")
    public suspend fun ssl(argument: suspend SslConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = SslConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ssl = mapped
    }

    internal fun build(): GlobalServiceConfigurationArgs = GlobalServiceConfigurationArgs(
        autoScale = autoScale,
        etag = etag,
        serviceAuth = serviceAuth,
        ssl = ssl,
    )
}
