@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * AppInsights credentials.
 * @property appId The AppInsights application ID.
 * @property instrumentationKey The AppInsights instrumentation key. This is not returned in response of GET/PUT on the resource. To see this please call listKeys API.
 */
public data class AppInsightsCredentialsResponse(
    public val appId: String? = null,
    public val instrumentationKey: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.AppInsightsCredentialsResponse):
            AppInsightsCredentialsResponse = AppInsightsCredentialsResponse(
            appId = javaType.appId().map({ args0 -> args0 }).orElse(null),
            instrumentationKey = javaType.instrumentationKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
