@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about the Azure Container Registry which contains the images deployed to the cluster.
 * @property loginServer The ACR login server name. User name is the first part of the FQDN.
 * @property password The ACR primary password.
 * @property password2 The ACR secondary password.
 * @property username The ACR login username.
 */
public data class ContainerRegistryCredentialsResponse(
    public val loginServer: String,
    public val password: String,
    public val password2: String,
    public val username: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.ContainerRegistryCredentialsResponse):
            ContainerRegistryCredentialsResponse = ContainerRegistryCredentialsResponse(
            loginServer = javaType.loginServer(),
            password = javaType.password(),
            password2 = javaType.password2(),
            username = javaType.username(),
        )
    }
}
