@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about the Azure Container Registry which contains the images deployed to the cluster.
 * @property acsKubeConfig The ACS kube config file.
 * @property imagePullSecretName The ACR image pull secret name which was created in Kubernetes.
 * @property servicePrincipalConfiguration Service principal configuration used by Kubernetes.
 */
public data class ContainerServiceCredentialsResponse(
    public val acsKubeConfig: String,
    public val imagePullSecretName: String,
    public val servicePrincipalConfiguration: ServicePrincipalPropertiesResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.ContainerServiceCredentialsResponse):
            ContainerServiceCredentialsResponse = ContainerServiceCredentialsResponse(
            acsKubeConfig = javaType.acsKubeConfig(),
            imagePullSecretName = javaType.imagePullSecretName(),
            servicePrincipalConfiguration = javaType.servicePrincipalConfiguration().let({ args0 ->
                com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ServicePrincipalPropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
