@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Error response information.
 * @property code Error code.
 * @property details An array of error detail objects.
 * @property message Error message.
 */
public data class ErrorResponseResponse(
    public val code: String,
    public val details: List<ErrorDetailResponse>? = null,
    public val message: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.ErrorResponseResponse):
            ErrorResponseResponse = ErrorResponseResponse(
            code = javaType.code(),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message(),
        )
    }
}
