@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Azure service principal used by Kubernetes for configuring load balancers
 * @property clientId The service principal client ID
 * @property secret The service principal secret. This is not returned in response of GET/PUT on the resource. To see this please call listKeys.
 */
public data class ServicePrincipalPropertiesResponse(
    public val clientId: String,
    public val secret: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.ServicePrincipalPropertiesResponse):
            ServicePrincipalPropertiesResponse = ServicePrincipalPropertiesResponse(
            clientId = javaType.clientId(),
            secret = javaType.secret(),
        )
    }
}
