@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about a system service deployed in the cluster
 * @property publicIpAddress The public IP address of the system service
 * @property systemServiceType The system service type
 * @property version The state of the system service
 */
public data class SystemServiceResponse(
    public val publicIpAddress: String,
    public val systemServiceType: String,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.SystemServiceResponse):
            SystemServiceResponse = SystemServiceResponse(
            publicIpAddress = javaType.publicIpAddress(),
            systemServiceType = javaType.systemServiceType(),
            version = javaType.version(),
        )
    }
}
