@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningexperimentation.kotlin

import com.pulumi.azurenative.machinelearningexperimentation.AccountArgs.builder
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.inputs.StorageAccountPropertiesArgs
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.inputs.StorageAccountPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An object that represents a machine learning team account.
 * Azure REST API version: 2017-05-01-preview. Prior API version in Azure Native 1.x: 2017-05-01-preview.
 * ## Example Usage
 * ### AccountCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.MachineLearningExperimentation.Account("account", new()
 *     {
 *         AccountName = "accountcrud5678",
 *         KeyVaultId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.KeyVault/vaults/testkv",
 *         Location = "East US",
 *         ResourceGroupName = "accountcrud-1234",
 *         StorageAccount = new AzureNative.MachineLearningExperimentation.Inputs.StorageAccountPropertiesArgs
 *         {
 *             AccessKey = "key",
 *             StorageAccountId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.Storage/storageAccounts/testStorageAccount",
 *         },
 *         Tags =
 *         {
 *             { "tagKey1", "TagValue1" },
 *         },
 *         VsoAccountId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/microsoft.visualstudio/account/vsotest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningexperimentation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningexperimentation.NewAccount(ctx, "account", &machinelearningexperimentation.AccountArgs{
 * 			AccountName:       pulumi.String("accountcrud5678"),
 * 			KeyVaultId:        pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.KeyVault/vaults/testkv"),
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("accountcrud-1234"),
 * 			StorageAccount: &machinelearningexperimentation.StorageAccountPropertiesArgs{
 * 				AccessKey:        pulumi.String("key"),
 * 				StorageAccountId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.Storage/storageAccounts/testStorageAccount"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tagKey1": pulumi.String("TagValue1"),
 * 			},
 * 			VsoAccountId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/microsoft.visualstudio/account/vsotest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningexperimentation.Account;
 * import com.pulumi.azurenative.machinelearningexperimentation.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("accountcrud5678")
 *             .keyVaultId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.KeyVault/vaults/testkv")
 *             .location("East US")
 *             .resourceGroupName("accountcrud-1234")
 *             .storageAccount(Map.ofEntries(
 *                 Map.entry("accessKey", "key"),
 *                 Map.entry("storageAccountId", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/Microsoft.Storage/storageAccounts/testStorageAccount")
 *             ))
 *             .tags(Map.of("tagKey1", "TagValue1"))
 *             .vsoAccountId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/accountcrud-1234/providers/microsoft.visualstudio/account/vsotest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningexperimentation:Account accountcrud5678 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}
 * ```
 * @property accountName The name of the machine learning team account.
 * @property description The description of this workspace.
 * @property friendlyName The friendly name for this workspace. This will be the workspace name in the arm id when the workspace object gets created
 * @property keyVaultId The fully qualified arm id of the user key vault.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property resourceGroupName The name of the resource group to which the machine learning team account belongs.
 * @property seats The no of users/seats who can access this team account. This property defines the charge on the team account.
 * @property storageAccount The properties of the storage account for the machine learning team account.
 * @property tags The tags of the resource.
 * @property vsoAccountId The fully qualified arm id of the vso account to be used for this team account.
 */
public data class AccountArgs(
    public val accountName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val keyVaultId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val seats: Output<String>? = null,
    public val storageAccount: Output<StorageAccountPropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vsoAccountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningexperimentation.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningexperimentation.AccountArgs =
        com.pulumi.azurenative.machinelearningexperimentation.AccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .keyVaultId(keyVaultId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .seats(seats?.applyValue({ args0 -> args0 }))
            .storageAccount(storageAccount?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vsoAccountId(vsoAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var description: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var keyVaultId: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var seats: Output<String>? = null

    private var storageAccount: Output<StorageAccountPropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vsoAccountId: Output<String>? = null

    /**
     * @param value The name of the machine learning team account.
     */
    @JvmName("kcsyrtkhsxndqmks")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The description of this workspace.
     */
    @JvmName("wvncoagkfdpemgia")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The friendly name for this workspace. This will be the workspace name in the arm id when the workspace object gets created
     */
    @JvmName("fxtogqxmpsiyqvey")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value The fully qualified arm id of the user key vault.
     */
    @JvmName("nxlfaxecxdornkyf")
    public suspend fun keyVaultId(`value`: Output<String>) {
        this.keyVaultId = value
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("mlgivohqnblkgjid")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group to which the machine learning team account belongs.
     */
    @JvmName("itcjvltmqwbebdbt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The no of users/seats who can access this team account. This property defines the charge on the team account.
     */
    @JvmName("qlnbhfnuqwkgvoov")
    public suspend fun seats(`value`: Output<String>) {
        this.seats = value
    }

    /**
     * @param value The properties of the storage account for the machine learning team account.
     */
    @JvmName("seulpylvkgrgllmw")
    public suspend fun storageAccount(`value`: Output<StorageAccountPropertiesArgs>) {
        this.storageAccount = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("vcvtrahcoqvmixcc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The fully qualified arm id of the vso account to be used for this team account.
     */
    @JvmName("einlhtrbowvwfsrw")
    public suspend fun vsoAccountId(`value`: Output<String>) {
        this.vsoAccountId = value
    }

    /**
     * @param value The name of the machine learning team account.
     */
    @JvmName("xvtyqeqylobpypqe")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The description of this workspace.
     */
    @JvmName("tbicqwuvtbuunxoa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The friendly name for this workspace. This will be the workspace name in the arm id when the workspace object gets created
     */
    @JvmName("dbwbguqsgocadlrc")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value The fully qualified arm id of the user key vault.
     */
    @JvmName("gtrmfphnondvtoqv")
    public suspend fun keyVaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultId = mapped
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("jcxbcgvevseoruii")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group to which the machine learning team account belongs.
     */
    @JvmName("wllrxfwfwlcptelf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The no of users/seats who can access this team account. This property defines the charge on the team account.
     */
    @JvmName("memuxbltlfjjkasg")
    public suspend fun seats(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.seats = mapped
    }

    /**
     * @param value The properties of the storage account for the machine learning team account.
     */
    @JvmName("errbbnrtwbvfxhbc")
    public suspend fun storageAccount(`value`: StorageAccountPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccount = mapped
    }

    /**
     * @param argument The properties of the storage account for the machine learning team account.
     */
    @JvmName("awfosfixjtamywxv")
    public suspend
    fun storageAccount(argument: suspend StorageAccountPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = StorageAccountPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageAccount = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("ylboirqnowroqfqd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("chldehijyxudqjvt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The fully qualified arm id of the vso account to be used for this team account.
     */
    @JvmName("evpdlfqoagafabyb")
    public suspend fun vsoAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vsoAccountId = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountName = accountName,
        description = description,
        friendlyName = friendlyName,
        keyVaultId = keyVaultId,
        location = location,
        resourceGroupName = resourceGroupName,
        seats = seats,
        storageAccount = storageAccount,
        tags = tags,
        vsoAccountId = vsoAccountId,
    )
}
