@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningexperimentation.kotlin.inputs

import com.pulumi.azurenative.machinelearningexperimentation.inputs.GetProjectPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the machine learning team account.
 * @property projectName The name of the machine learning project under a team account workspace.
 * @property resourceGroupName The name of the resource group to which the machine learning team account belongs.
 * @property workspaceName The name of the machine learning team account workspace.
 */
public data class GetProjectPlainArgs(
    public val accountName: String,
    public val projectName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningexperimentation.inputs.GetProjectPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningexperimentation.inputs.GetProjectPlainArgs =
        com.pulumi.azurenative.machinelearningexperimentation.inputs.GetProjectPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectPlainArgs].
 */
@PulumiTagMarker
public class GetProjectPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the machine learning team account.
     */
    @JvmName("wvmvmgitmskdmknd")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the machine learning project under a team account workspace.
     */
    @JvmName("homxcrbwifurtavl")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group to which the machine learning team account belongs.
     */
    @JvmName("wunukubhaawiceyy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the machine learning team account workspace.
     */
    @JvmName("ipckwolelrruqbjw")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetProjectPlainArgs = GetProjectPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
