@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningexperimentation.kotlin.inputs

import com.pulumi.azurenative.machinelearningexperimentation.inputs.GetWorkspacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the machine learning team account.
 * @property resourceGroupName The name of the resource group to which the machine learning team account belongs.
 * @property workspaceName The name of the machine learning team account workspace.
 */
public data class GetWorkspacePlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningexperimentation.inputs.GetWorkspacePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningexperimentation.inputs.GetWorkspacePlainArgs =
        com.pulumi.azurenative.machinelearningexperimentation.inputs.GetWorkspacePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspacePlainArgs].
 */
@PulumiTagMarker
public class GetWorkspacePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the machine learning team account.
     */
    @JvmName("ulheamacdmdykjgk")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group to which the machine learning team account belongs.
     */
    @JvmName("moajfdhjwdueewkl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the machine learning team account workspace.
     */
    @JvmName("fosotmmfowjprpsw")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetWorkspacePlainArgs = GetWorkspacePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
