@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningexperimentation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An object that represents a machine learning team account workspace.
 * @property accountId The immutable id of the team account which contains this workspace.
 * @property creationDate The creation date of the machine learning workspace in ISO8601 format.
 * @property description The description of this workspace.
 * @property friendlyName The friendly name for this workspace. This will be the workspace name in the arm id when the workspace object gets created
 * @property id The resource ID.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property name The name of the resource.
 * @property provisioningState The current deployment state of team account workspace resource. The provisioningState is to indicate states for resource provisioning.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property workspaceId The immutable id of this workspace.
 */
public data class GetWorkspaceResult(
    public val accountId: String,
    public val creationDate: String,
    public val description: String? = null,
    public val friendlyName: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val workspaceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningexperimentation.outputs.GetWorkspaceResult):
            GetWorkspaceResult = GetWorkspaceResult(
            accountId = javaType.accountId(),
            creationDate = javaType.creationDate(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            workspaceId = javaType.workspaceId(),
        )
    }
}
