@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningexperimentation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of a storage account for a machine learning team account.
 * @property accessKey The access key to the storage account.
 * @property storageAccountId The fully qualified arm Id of the storage account.
 */
public data class StorageAccountPropertiesResponse(
    public val accessKey: String,
    public val storageAccountId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningexperimentation.outputs.StorageAccountPropertiesResponse):
            StorageAccountPropertiesResponse = StorageAccountPropertiesResponse(
            accessKey = javaType.accessKey(),
            storageAccountId = javaType.storageAccountId(),
        )
    }
}
