@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.ComponentVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-02-01-preview.
 * Other available API versions: 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Component Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var componentVersion = new AzureNative.MachineLearningServices.ComponentVersion("componentVersion", new()
 *     {
 *         ComponentVersionProperties = new AzureNative.MachineLearningServices.Inputs.ComponentVersionArgs
 *         {
 *             ComponentSpec =
 *             {
 *                 { "8ced901b-d826-477d-bfef-329da9672513", null },
 *             },
 *             Description = "string",
 *             IsAnonymous = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewComponentVersion(ctx, "componentVersion", &machinelearningservices.ComponentVersionArgs{
 * ComponentVersionProperties: &machinelearningservices.ComponentVersionTypeArgs{
 * ComponentSpec: pulumi.Any{
 * 8ced901bD826477dBfef329da9672513: nil,
 * },
 * Description: pulumi.String("string"),
 * IsAnonymous: pulumi.Bool(false),
 * Properties: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * Tags: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * },
 * Name: pulumi.String("string"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * Version: pulumi.String("string"),
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.ComponentVersion;
 * import com.pulumi.azurenative.machinelearningservices.ComponentVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var componentVersion = new ComponentVersion("componentVersion", ComponentVersionArgs.builder()
 *             .componentVersionProperties(Map.ofEntries(
 *                 Map.entry("componentSpec", Map.of("8ced901b-d826-477d-bfef-329da9672513", null)),
 *                 Map.entry("description", "string"),
 *                 Map.entry("isAnonymous", false),
 *                 Map.entry("properties", Map.of("string", "string")),
 *                 Map.entry("tags", Map.of("string", "string"))
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:ComponentVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/components/{name}/versions/{version}
 * ```
 * @property componentVersionProperties [Required] Additional attributes of the entity.
 * @property name Container name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class ComponentVersionArgs(
    public val componentVersionProperties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ComponentVersionArgs>? =
        null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val version: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.ComponentVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.ComponentVersionArgs =
        com.pulumi.azurenative.machinelearningservices.ComponentVersionArgs.builder()
            .componentVersionProperties(
                componentVersionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComponentVersionArgs].
 */
@PulumiTagMarker
public class ComponentVersionArgsBuilder internal constructor() {
    private var componentVersionProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ComponentVersionArgs>? =
        null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var version: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("bjpdqahkugocetxp")
    public suspend
    fun componentVersionProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ComponentVersionArgs>) {
        this.componentVersionProperties = value
    }

    /**
     * @param value Container name.
     */
    @JvmName("nkknqwlybxvxdxiv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("upkeegechvpxujys")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("sqhkuebkmeabanba")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("rhrgwvyrhtkpajib")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("hvibjgudqmrxenkq")
    public suspend
    fun componentVersionProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ComponentVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentVersionProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("mbreatuodbbdsjra")
    public suspend
    fun componentVersionProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ComponentVersionArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ComponentVersionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.componentVersionProperties = mapped
    }

    /**
     * @param value Container name.
     */
    @JvmName("byrtyroccertjwuu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("owmbbdblghkxnqlq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("rnpkovabqecuxois")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("bloxfuvsvcmfhisg")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ComponentVersionArgs = ComponentVersionArgs(
        componentVersionProperties = componentVersionProperties,
        name = name,
        resourceGroupName = resourceGroupName,
        version = version,
        workspaceName = workspaceName,
    )
}
