@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Datastore].
 */
@PulumiTagMarker
public class DatastoreResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatastoreArgs = DatastoreArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatastoreArgsBuilder.() -> Unit) {
        val builder = DatastoreArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Datastore {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.Datastore(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Datastore(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate datastore (Azure Data Lake Gen1 w/ ServicePrincipal).
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var datastore = new AzureNative.MachineLearningServices.Datastore("datastore", new()
 *     {
 *         DatastoreProperties = new AzureNative.MachineLearningServices.Inputs.AzureDataLakeGen1DatastoreArgs
 *         {
 *             Credentials = new AzureNative.MachineLearningServices.Inputs.ServicePrincipalDatastoreCredentialsArgs
 *             {
 *                 AuthorityUrl = "string",
 *                 ClientId = "00000000-1111-2222-3333-444444444444",
 *                 CredentialsType = "ServicePrincipal",
 *                 ResourceUrl = "string",
 *                 Secrets = new AzureNative.MachineLearningServices.Inputs.ServicePrincipalDatastoreSecretsArgs
 *                 {
 *                     ClientSecret = "string",
 *                     SecretsType = "ServicePrincipal",
 *                 },
 *                 TenantId = "00000000-1111-2222-3333-444444444444",
 *             },
 *             DatastoreType = "AzureDataLakeGen1",
 *             Description = "string",
 *             StoreName = "string",
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         SkipValidation = false,
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewDatastore(ctx, "datastore", &machinelearningservices.DatastoreArgs{
 * 			DatastoreProperties: machinelearningservices.AzureDataLakeGen1Datastore{
 * 				Credentials: machinelearningservices.ServicePrincipalDatastoreCredentials{
 * 					AuthorityUrl:    "string",
 * 					ClientId:        "00000000-1111-2222-3333-444444444444",
 * 					CredentialsType: "ServicePrincipal",
 * 					ResourceUrl:     "string",
 * 					Secrets: machinelearningservices.ServicePrincipalDatastoreSecrets{
 * 						ClientSecret: "string",
 * 						SecretsType:  "ServicePrincipal",
 * 					},
 * 					TenantId: "00000000-1111-2222-3333-444444444444",
 * 				},
 * 				DatastoreType: "AzureDataLakeGen1",
 * 				Description:   "string",
 * 				StoreName:     "string",
 * 				Tags: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SkipValidation:    pulumi.Bool(false),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Datastore;
 * import com.pulumi.azurenative.machinelearningservices.DatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var datastore = new Datastore("datastore", DatastoreArgs.builder()
 *             .datastoreProperties(Map.ofEntries(
 *                 Map.entry("credentials", Map.ofEntries(
 *                     Map.entry("authorityUrl", "string"),
 *                     Map.entry("clientId", "00000000-1111-2222-3333-444444444444"),
 *                     Map.entry("credentialsType", "ServicePrincipal"),
 *                     Map.entry("resourceUrl", "string"),
 *                     Map.entry("secrets", Map.ofEntries(
 *                         Map.entry("clientSecret", "string"),
 *                         Map.entry("secretsType", "ServicePrincipal")
 *                     )),
 *                     Map.entry("tenantId", "00000000-1111-2222-3333-444444444444")
 *                 )),
 *                 Map.entry("datastoreType", "AzureDataLakeGen1"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("storeName", "string"),
 *                 Map.entry("tags", AzureBlobDatastoreArgs.builder()
 *                     .string("string")
 *                     .build())
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .skipValidation(false)
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate datastore (Azure Data Lake Gen2 w/ Service Principal).
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var datastore = new AzureNative.MachineLearningServices.Datastore("datastore", new()
 *     {
 *         DatastoreProperties = new AzureNative.MachineLearningServices.Inputs.AzureDataLakeGen2DatastoreArgs
 *         {
 *             AccountName = "string",
 *             Credentials = new AzureNative.MachineLearningServices.Inputs.ServicePrincipalDatastoreCredentialsArgs
 *             {
 *                 AuthorityUrl = "string",
 *                 ClientId = "00000000-1111-2222-3333-444444444444",
 *                 CredentialsType = "ServicePrincipal",
 *                 ResourceUrl = "string",
 *                 Secrets = new AzureNative.MachineLearningServices.Inputs.ServicePrincipalDatastoreSecretsArgs
 *                 {
 *                     ClientSecret = "string",
 *                     SecretsType = "ServicePrincipal",
 *                 },
 *                 TenantId = "00000000-1111-2222-3333-444444444444",
 *             },
 *             DatastoreType = "AzureDataLakeGen2",
 *             Description = "string",
 *             Endpoint = "string",
 *             Filesystem = "string",
 *             Protocol = "string",
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         SkipValidation = false,
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewDatastore(ctx, "datastore", &machinelearningservices.DatastoreArgs{
 * 			DatastoreProperties: machinelearningservices.AzureDataLakeGen2Datastore{
 * 				AccountName: "string",
 * 				Credentials: machinelearningservices.ServicePrincipalDatastoreCredentials{
 * 					AuthorityUrl:    "string",
 * 					ClientId:        "00000000-1111-2222-3333-444444444444",
 * 					CredentialsType: "ServicePrincipal",
 * 					ResourceUrl:     "string",
 * 					Secrets: machinelearningservices.ServicePrincipalDatastoreSecrets{
 * 						ClientSecret: "string",
 * 						SecretsType:  "ServicePrincipal",
 * 					},
 * 					TenantId: "00000000-1111-2222-3333-444444444444",
 * 				},
 * 				DatastoreType: "AzureDataLakeGen2",
 * 				Description:   "string",
 * 				Endpoint:      "string",
 * 				Filesystem:    "string",
 * 				Protocol:      "string",
 * 				Tags: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SkipValidation:    pulumi.Bool(false),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Datastore;
 * import com.pulumi.azurenative.machinelearningservices.DatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var datastore = new Datastore("datastore", DatastoreArgs.builder()
 *             .datastoreProperties(Map.ofEntries(
 *                 Map.entry("accountName", "string"),
 *                 Map.entry("credentials", Map.ofEntries(
 *                     Map.entry("authorityUrl", "string"),
 *                     Map.entry("clientId", "00000000-1111-2222-3333-444444444444"),
 *                     Map.entry("credentialsType", "ServicePrincipal"),
 *                     Map.entry("resourceUrl", "string"),
 *                     Map.entry("secrets", Map.ofEntries(
 *                         Map.entry("clientSecret", "string"),
 *                         Map.entry("secretsType", "ServicePrincipal")
 *                     )),
 *                     Map.entry("tenantId", "00000000-1111-2222-3333-444444444444")
 *                 )),
 *                 Map.entry("datastoreType", "AzureDataLakeGen2"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("endpoint", "string"),
 *                 Map.entry("filesystem", "string"),
 *                 Map.entry("protocol", "string"),
 *                 Map.entry("tags", AzureBlobDatastoreArgs.builder()
 *                     .string("string")
 *                     .build())
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .skipValidation(false)
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate datastore (Azure File store w/ AccountKey).
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var datastore = new AzureNative.MachineLearningServices.Datastore("datastore", new()
 *     {
 *         DatastoreProperties = new AzureNative.MachineLearningServices.Inputs.AzureFileDatastoreArgs
 *         {
 *             AccountName = "string",
 *             Credentials = new AzureNative.MachineLearningServices.Inputs.AccountKeyDatastoreCredentialsArgs
 *             {
 *                 CredentialsType = "AccountKey",
 *                 Secrets = new AzureNative.MachineLearningServices.Inputs.AccountKeyDatastoreSecretsArgs
 *                 {
 *                     Key = "string",
 *                     SecretsType = "AccountKey",
 *                 },
 *             },
 *             DatastoreType = "AzureFile",
 *             Description = "string",
 *             Endpoint = "string",
 *             FileShareName = "string",
 *             Protocol = "string",
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         SkipValidation = false,
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewDatastore(ctx, "datastore", &machinelearningservices.DatastoreArgs{
 * 			DatastoreProperties: machinelearningservices.AzureFileDatastore{
 * 				AccountName: "string",
 * 				Credentials: machinelearningservices.AccountKeyDatastoreCredentials{
 * 					CredentialsType: "AccountKey",
 * 					Secrets: machinelearningservices.AccountKeyDatastoreSecrets{
 * 						Key:         "string",
 * 						SecretsType: "AccountKey",
 * 					},
 * 				},
 * 				DatastoreType: "AzureFile",
 * 				Description:   "string",
 * 				Endpoint:      "string",
 * 				FileShareName: "string",
 * 				Protocol:      "string",
 * 				Tags: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SkipValidation:    pulumi.Bool(false),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Datastore;
 * import com.pulumi.azurenative.machinelearningservices.DatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var datastore = new Datastore("datastore", DatastoreArgs.builder()
 *             .datastoreProperties(Map.ofEntries(
 *                 Map.entry("accountName", "string"),
 *                 Map.entry("credentials", Map.ofEntries(
 *                     Map.entry("credentialsType", "AccountKey"),
 *                     Map.entry("secrets", Map.ofEntries(
 *                         Map.entry("key", "string"),
 *                         Map.entry("secretsType", "AccountKey")
 *                     ))
 *                 )),
 *                 Map.entry("datastoreType", "AzureFile"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("endpoint", "string"),
 *                 Map.entry("fileShareName", "string"),
 *                 Map.entry("protocol", "string"),
 *                 Map.entry("tags", AzureBlobDatastoreArgs.builder()
 *                     .string("string")
 *                     .build())
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .skipValidation(false)
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate datastore (AzureBlob w/ AccountKey).
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var datastore = new AzureNative.MachineLearningServices.Datastore("datastore", new()
 *     {
 *         DatastoreProperties = new AzureNative.MachineLearningServices.Inputs.AzureBlobDatastoreArgs
 *         {
 *             AccountName = "string",
 *             ContainerName = "string",
 *             Credentials = new AzureNative.MachineLearningServices.Inputs.AccountKeyDatastoreCredentialsArgs
 *             {
 *                 CredentialsType = "AccountKey",
 *                 Secrets = new AzureNative.MachineLearningServices.Inputs.AccountKeyDatastoreSecretsArgs
 *                 {
 *                     Key = "string",
 *                     SecretsType = "AccountKey",
 *                 },
 *             },
 *             DatastoreType = "AzureBlob",
 *             Description = "string",
 *             Endpoint = "core.windows.net",
 *             Protocol = "https",
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         SkipValidation = false,
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewDatastore(ctx, "datastore", &machinelearningservices.DatastoreArgs{
 * 			DatastoreProperties: machinelearningservices.AzureBlobDatastore{
 * 				AccountName:   "string",
 * 				ContainerName: "string",
 * 				Credentials: machinelearningservices.AccountKeyDatastoreCredentials{
 * 					CredentialsType: "AccountKey",
 * 					Secrets: machinelearningservices.AccountKeyDatastoreSecrets{
 * 						Key:         "string",
 * 						SecretsType: "AccountKey",
 * 					},
 * 				},
 * 				DatastoreType: "AzureBlob",
 * 				Description:   "string",
 * 				Endpoint:      "core.windows.net",
 * 				Protocol:      "https",
 * 				Tags: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SkipValidation:    pulumi.Bool(false),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Datastore;
 * import com.pulumi.azurenative.machinelearningservices.DatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var datastore = new Datastore("datastore", DatastoreArgs.builder()
 *             .datastoreProperties(Map.ofEntries(
 *                 Map.entry("accountName", "string"),
 *                 Map.entry("containerName", "string"),
 *                 Map.entry("credentials", Map.ofEntries(
 *                     Map.entry("credentialsType", "AccountKey"),
 *                     Map.entry("secrets", Map.ofEntries(
 *                         Map.entry("key", "string"),
 *                         Map.entry("secretsType", "AccountKey")
 *                     ))
 *                 )),
 *                 Map.entry("datastoreType", "AzureBlob"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("endpoint", "core.windows.net"),
 *                 Map.entry("protocol", "https"),
 *                 Map.entry("tags", AzureBlobDatastoreArgs.builder()
 *                     .string("string")
 *                     .build())
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .skipValidation(false)
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:Datastore string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/datastores/{name}
 * ```
 */
public class Datastore internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.Datastore,
) : KotlinCustomResource(javaResource, DatastoreMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val datastoreProperties: Output<Any>
        get() = javaResource.datastoreProperties().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DatastoreMapper : ResourceMapper<Datastore> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.Datastore::class == javaResource::class

    override fun map(javaResource: Resource): Datastore = Datastore(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.Datastore,
    )
}

/**
 * @see [Datastore].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Datastore].
 */
public suspend fun datastore(name: String, block: suspend DatastoreResourceBuilder.() -> Unit):
    Datastore {
    val builder = DatastoreResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Datastore].
 * @param name The _unique_ name of the resulting resource.
 */
public fun datastore(name: String): Datastore {
    val builder = DatastoreResourceBuilder()
    builder.name(name)
    return builder.build()
}
