@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.EnvironmentContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Environment Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var environmentContainer = new AzureNative.MachineLearningServices.EnvironmentContainer("environmentContainer", new()
 *     {
 *         EnvironmentContainerProperties = new AzureNative.MachineLearningServices.Inputs.EnvironmentContainerArgs
 *         {
 *             Description = "string",
 *             Properties =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *         },
 *         Name = "testEnvironment",
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "testworkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewEnvironmentContainer(ctx, "environmentContainer", &machinelearningservices.EnvironmentContainerArgs{
 * 			EnvironmentContainerProperties: &machinelearningservices.EnvironmentContainerTypeArgs{
 * 				Description: pulumi.String("string"),
 * 				Properties: pulumi.StringMap{
 * 					"additionalProp1": pulumi.String("string"),
 * 					"additionalProp2": pulumi.String("string"),
 * 					"additionalProp3": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"additionalProp1": pulumi.String("string"),
 * 					"additionalProp2": pulumi.String("string"),
 * 					"additionalProp3": pulumi.String("string"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("testEnvironment"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("testworkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.EnvironmentContainer;
 * import com.pulumi.azurenative.machinelearningservices.EnvironmentContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var environmentContainer = new EnvironmentContainer("environmentContainer", EnvironmentContainerArgs.builder()
 *             .environmentContainerProperties(Map.ofEntries(
 *                 Map.entry("description", "string"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 )),
 *                 Map.entry("tags", Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 ))
 *             ))
 *             .name("testEnvironment")
 *             .resourceGroupName("testrg123")
 *             .workspaceName("testworkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:EnvironmentContainer testEnvironment /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/environments/{name}
 * ```
 * @property environmentContainerProperties [Required] Additional attributes of the entity.
 * @property name Container name. This is case-sensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class EnvironmentContainerArgs(
    public val environmentContainerProperties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentContainerArgs>? =
        null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.EnvironmentContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.EnvironmentContainerArgs =
        com.pulumi.azurenative.machinelearningservices.EnvironmentContainerArgs.builder()
            .environmentContainerProperties(
                environmentContainerProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentContainerArgs].
 */
@PulumiTagMarker
public class EnvironmentContainerArgsBuilder internal constructor() {
    private var environmentContainerProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentContainerArgs>? =
        null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("dxajjsfkfdserhko")
    public suspend
    fun environmentContainerProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentContainerArgs>) {
        this.environmentContainerProperties = value
    }

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("gbmdtmtejghsrbre")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hnksucaplihfkwer")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("udcerjbvfgkpxwys")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("qiwotbtuodrsasyw")
    public suspend
    fun environmentContainerProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentContainerProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("veylylpaqqrabxlv")
    public suspend
    fun environmentContainerProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentContainerArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentContainerArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.environmentContainerProperties = mapped
    }

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("ncfnscyjhivdnpmb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lncpjthusvkltxul")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("xpswpayxtuwoksii")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): EnvironmentContainerArgs = EnvironmentContainerArgs(
        environmentContainerProperties = environmentContainerProperties,
        name = name,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
