@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.FeaturesetVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Featureset Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var featuresetVersion = new AzureNative.MachineLearningServices.FeaturesetVersion("featuresetVersion", new()
 *     {
 *         FeaturesetVersionProperties = new AzureNative.MachineLearningServices.Inputs.FeaturesetVersionArgs
 *         {
 *             Description = "string",
 *             Entities = new[]
 *             {
 *                 "string",
 *             },
 *             IsAnonymous = false,
 *             IsArchived = false,
 *             MaterializationSettings = new AzureNative.MachineLearningServices.Inputs.MaterializationSettingsArgs
 *             {
 *                 Notification = new AzureNative.MachineLearningServices.Inputs.NotificationSettingArgs
 *                 {
 *                     EmailOn = new[]
 *                     {
 *                         "JobFailed",
 *                     },
 *                     Emails = new[]
 *                     {
 *                         "string",
 *                     },
 *                 },
 *                 Resource = new AzureNative.MachineLearningServices.Inputs.MaterializationComputeResourceArgs
 *                 {
 *                     InstanceType = "string",
 *                 },
 *                 Schedule =
 *                 {
 *                     { "endTime", "string" },
 *                     { "frequency", "Day" },
 *                     { "interval", 1 },
 *                     { "schedule", new AzureNative.MachineLearningServices.Inputs.RecurrenceScheduleArgs
 *                     {
 *                         Hours = new[]
 *                         {
 *                             1,
 *                         },
 *                         Minutes = new[]
 *                         {
 *                             1,
 *                         },
 *                         MonthDays = new[]
 *                         {
 *                             1,
 *                         },
 *                         WeekDays = new[]
 *                         {
 *                             "Monday",
 *                         },
 *                     } },
 *                     { "startTime", "string" },
 *                     { "timeZone", "string" },
 *                     { "triggerType", "Recurrence" },
 *                 },
 *                 SparkConfiguration =
 *                 {
 *                     { "string", "string" },
 *                 },
 *                 StoreType = "Online",
 *             },
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Specification = new AzureNative.MachineLearningServices.Inputs.FeaturesetSpecificationArgs
 *             {
 *                 Path = "string",
 *             },
 *             Stage = "string",
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewFeaturesetVersion(ctx, "featuresetVersion", &machinelearningservices.FeaturesetVersionArgs{
 * FeaturesetVersionProperties: machinelearningservices.FeaturesetVersionResponse{
 * Description: pulumi.String("string"),
 * Entities: pulumi.StringArray{
 * pulumi.String("string"),
 * },
 * IsAnonymous: pulumi.Bool(false),
 * IsArchived: pulumi.Bool(false),
 * MaterializationSettings: interface{}{
 * Notification: &machinelearningservices.NotificationSettingArgs{
 * EmailOn: pulumi.StringArray{
 * pulumi.String("JobFailed"),
 * },
 * Emails: pulumi.StringArray{
 * pulumi.String("string"),
 * },
 * },
 * Resource: &machinelearningservices.MaterializationComputeResourceArgs{
 * InstanceType: pulumi.String("string"),
 * },
 * Schedule: interface{}{
 * EndTime: pulumi.String("string"),
 * Frequency: pulumi.String("Day"),
 * Interval: pulumi.Int(1),
 * Schedule: &machinelearningservices.RecurrenceScheduleArgs{
 * Hours: pulumi.IntArray{
 * pulumi.Int(1),
 * },
 * Minutes: pulumi.IntArray{
 * pulumi.Int(1),
 * },
 * MonthDays: pulumi.IntArray{
 * pulumi.Int(1),
 * },
 * WeekDays: pulumi.StringArray{
 * pulumi.String("Monday"),
 * },
 * },
 * StartTime: pulumi.String("string"),
 * TimeZone: pulumi.String("string"),
 * TriggerType: pulumi.String("Recurrence"),
 * },
 * SparkConfiguration: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * StoreType: pulumi.String("Online"),
 * },
 * Properties: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * Specification: &machinelearningservices.FeaturesetSpecificationArgs{
 * Path: pulumi.String("string"),
 * },
 * Stage: pulumi.String("string"),
 * Tags: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * },
 * Name: pulumi.String("string"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * Version: pulumi.String("string"),
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.FeaturesetVersion;
 * import com.pulumi.azurenative.machinelearningservices.FeaturesetVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var featuresetVersion = new FeaturesetVersion("featuresetVersion", FeaturesetVersionArgs.builder()
 *             .featuresetVersionProperties(Map.ofEntries(
 *                 Map.entry("description", "string"),
 *                 Map.entry("entities", "string"),
 *                 Map.entry("isAnonymous", false),
 *                 Map.entry("isArchived", false),
 *                 Map.entry("materializationSettings", Map.ofEntries(
 *                     Map.entry("notification", Map.ofEntries(
 *                         Map.entry("emailOn", "JobFailed"),
 *                         Map.entry("emails", "string")
 *                     )),
 *                     Map.entry("resource", Map.of("instanceType", "string")),
 *                     Map.entry("schedule", Map.ofEntries(
 *                         Map.entry("endTime", "string"),
 *                         Map.entry("frequency", "Day"),
 *                         Map.entry("interval", 1),
 *                         Map.entry("schedule", Map.ofEntries(
 *                             Map.entry("hours", 1),
 *                             Map.entry("minutes", 1),
 *                             Map.entry("monthDays", 1),
 *                             Map.entry("weekDays", "Monday")
 *                         )),
 *                         Map.entry("startTime", "string"),
 *                         Map.entry("timeZone", "string"),
 *                         Map.entry("triggerType", "Recurrence")
 *                     )),
 *                     Map.entry("sparkConfiguration", Map.of("string", "string")),
 *                     Map.entry("storeType", "Online")
 *                 )),
 *                 Map.entry("properties", Map.of("string", "string")),
 *                 Map.entry("specification", Map.of("path", "string")),
 *                 Map.entry("stage", "string"),
 *                 Map.entry("tags", Map.of("string", "string"))
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:FeaturesetVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/featuresets/{name}/versions/{version}
 * ```
 * @property featuresetVersionProperties [Required] Additional attributes of the entity.
 * @property name Container name. This is case-sensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier. This is case-sensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class FeaturesetVersionArgs(
    public val featuresetVersionProperties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturesetVersionArgs>? =
        null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val version: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.FeaturesetVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.FeaturesetVersionArgs =
        com.pulumi.azurenative.machinelearningservices.FeaturesetVersionArgs.builder()
            .featuresetVersionProperties(
                featuresetVersionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FeaturesetVersionArgs].
 */
@PulumiTagMarker
public class FeaturesetVersionArgsBuilder internal constructor() {
    private var featuresetVersionProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturesetVersionArgs>? =
        null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var version: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("kcheijhhyycahffi")
    public suspend
    fun featuresetVersionProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturesetVersionArgs>) {
        this.featuresetVersionProperties = value
    }

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("wilmdjbpyfkosacn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hwcnerfvjshgnvuv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Version identifier. This is case-sensitive.
     */
    @JvmName("orwpvcpabaybrvqc")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("pgqvlpqvitxqvlow")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("wprxrjrqrfpbbmyc")
    public suspend
    fun featuresetVersionProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturesetVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featuresetVersionProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("piavrlantpppegyq")
    public suspend
    fun featuresetVersionProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturesetVersionArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturesetVersionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.featuresetVersionProperties = mapped
    }

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("jvgovjclpnclxguo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yrinmkyjwmvaxcsp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier. This is case-sensitive.
     */
    @JvmName("ikvhteppepskvxqn")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("nefweggnbulwkodp")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): FeaturesetVersionArgs = FeaturesetVersionArgs(
        featuresetVersionProperties = featuresetVersionProperties,
        name = name,
        resourceGroupName = resourceGroupName,
        version = version,
        workspaceName = workspaceName,
    )
}
