@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.InferenceGroupArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-08-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:InferenceGroup string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/inferencePools/{poolName}/groups/{groupName}
 * ```
 * @property groupName InferenceGroup name.
 * @property identity Managed service identity (system assigned and/or user assigned identities)
 * @property inferenceGroupProperties [Required] Additional attributes of the entity.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
 * @property location The geo-location where the resource lives
 * @property poolName InferencePool name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku Sku details required for ARM contract for Autoscaling.
 * @property tags Resource tags.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class InferenceGroupArgs(
    public val groupName: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val inferenceGroupProperties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.InferenceGroupArgs>? =
        null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val poolName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.InferenceGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.InferenceGroupArgs =
        com.pulumi.azurenative.machinelearningservices.InferenceGroupArgs.builder()
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inferenceGroupProperties(
                inferenceGroupProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InferenceGroupArgs].
 */
@PulumiTagMarker
public class InferenceGroupArgsBuilder internal constructor() {
    private var groupName: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var inferenceGroupProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.InferenceGroupArgs>? =
        null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var poolName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value InferenceGroup name.
     */
    @JvmName("moslnbfljsucolhe")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("ftwcujpwfvuturmb")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("yqpfnimphwfwqysq")
    public suspend
    fun inferenceGroupProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.InferenceGroupArgs>) {
        this.inferenceGroupProperties = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
     */
    @JvmName("pdovirsnsokgxhgo")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("iiqcbpyqtjrwexqy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value InferencePool name.
     */
    @JvmName("doselebwvbpydjss")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ypuwcsilkejdkxqb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("nygkooobvqhywior")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iicylbyjkefgjwbr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("ircxtlasrgxcsqpn")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value InferenceGroup name.
     */
    @JvmName("arxrgcxihmocxdti")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("wmokwukooukchest")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("objpveqkuoilkfcx")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("anfjltpllmvtjjvr")
    public suspend
    fun inferenceGroupProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.InferenceGroupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inferenceGroupProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("untynuqtighyivix")
    public suspend
    fun inferenceGroupProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.InferenceGroupArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.InferenceGroupArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.inferenceGroupProperties = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
     */
    @JvmName("ebllxdkaqxbcscqb")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("earacnoukmnewxjh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value InferencePool name.
     */
    @JvmName("jbvupiqsotimtmvb")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ufvkiuoviqnesolt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("bmeqqagobunssasa")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("tcmmxswrlvfwurfk")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bcscihponavsqccr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("bntbbquwncvintdm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("ictprnismmmcdyhi")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): InferenceGroupArgs = InferenceGroupArgs(
        groupName = groupName,
        identity = identity,
        inferenceGroupProperties = inferenceGroupProperties,
        kind = kind,
        location = location,
        poolName = poolName,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        workspaceName = workspaceName,
    )
}
