@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.MachineLearningDatasetArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.DatasetType
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DatasetCreateRequestParametersArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DatasetCreateRequestParametersArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DatasetCreateRequestRegistrationArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DatasetCreateRequestRegistrationArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DatasetCreateRequestTimeSeriesArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DatasetCreateRequestTimeSeriesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Machine Learning dataset object wrapped into ARM resource envelope.
 * Azure REST API version: 2020-05-01-preview. Prior API version in Azure Native 1.x: 2020-05-01-preview.
 * ## Example Usage
 * ### Create Dataset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDataset = new AzureNative.MachineLearningServices.MachineLearningDataset("machineLearningDataset", new()
 *     {
 *         DatasetName = "datasetName123",
 *         DatasetType = "file",
 *         Parameters = new AzureNative.MachineLearningServices.Inputs.DatasetCreateRequestParametersArgs
 *         {
 *             Path = new AzureNative.MachineLearningServices.Inputs.DatasetCreateRequestPathArgs
 *             {
 *                 DataPath = new AzureNative.MachineLearningServices.Inputs.DatasetCreateRequestDataPathArgs
 *                 {
 *                     DatastoreName = "testblobfromarm",
 *                     RelativePath = "UI/03-26-2020_083359_UTC/latin1encoding.csv",
 *                 },
 *             },
 *         },
 *         Registration = new AzureNative.MachineLearningServices.Inputs.DatasetCreateRequestRegistrationArgs
 *         {
 *             Description = "test description",
 *             Name = "datasetName123",
 *         },
 *         ResourceGroupName = "acjain-mleastUS2",
 *         SkipValidation = false,
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDataset(ctx, "machineLearningDataset", &machinelearningservices.MachineLearningDatasetArgs{
 * 			DatasetName: pulumi.String("datasetName123"),
 * 			DatasetType: pulumi.String("file"),
 * 			Parameters: &machinelearningservices.DatasetCreateRequestParametersArgs{
 * 				Path: &machinelearningservices.DatasetCreateRequestPathArgs{
 * 					DataPath: &machinelearningservices.DatasetCreateRequestDataPathArgs{
 * 						DatastoreName: pulumi.String("testblobfromarm"),
 * 						RelativePath:  pulumi.String("UI/03-26-2020_083359_UTC/latin1encoding.csv"),
 * 					},
 * 				},
 * 			},
 * 			Registration: &machinelearningservices.DatasetCreateRequestRegistrationArgs{
 * 				Description: pulumi.String("test description"),
 * 				Name:        pulumi.String("datasetName123"),
 * 			},
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			SkipValidation:    pulumi.Bool(false),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDataset;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatasetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDataset = new MachineLearningDataset("machineLearningDataset", MachineLearningDatasetArgs.builder()
 *             .datasetName("datasetName123")
 *             .datasetType("file")
 *             .parameters(Map.of("path", Map.of("dataPath", Map.ofEntries(
 *                 Map.entry("datastoreName", "testblobfromarm"),
 *                 Map.entry("relativePath", "UI/03-26-2020_083359_UTC/latin1encoding.csv")
 *             ))))
 *             .registration(Map.ofEntries(
 *                 Map.entry("description", "test description"),
 *                 Map.entry("name", "datasetName123")
 *             ))
 *             .resourceGroupName("acjain-mleastUS2")
 *             .skipValidation(false)
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:MachineLearningDataset datasetName123 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/datasets/{datasetName}
 * ```
 * @property datasetName The Dataset name.
 * @property datasetType Specifies dataset type.
 * @property parameters
 * @property registration
 * @property resourceGroupName Name of the resource group in which workspace is located.
 * @property skipValidation Skip validation that ensures data can be loaded from the dataset before registration.
 * @property timeSeries
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class MachineLearningDatasetArgs(
    public val datasetName: Output<String>? = null,
    public val datasetType: Output<Either<String, DatasetType>>? = null,
    public val parameters: Output<DatasetCreateRequestParametersArgs>? = null,
    public val registration: Output<DatasetCreateRequestRegistrationArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val skipValidation: Output<Boolean>? = null,
    public val timeSeries: Output<DatasetCreateRequestTimeSeriesArgs>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.MachineLearningDatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.MachineLearningDatasetArgs =
        com.pulumi.azurenative.machinelearningservices.MachineLearningDatasetArgs.builder()
            .datasetName(datasetName?.applyValue({ args0 -> args0 }))
            .datasetType(
                datasetType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .parameters(parameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registration(registration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .skipValidation(skipValidation?.applyValue({ args0 -> args0 }))
            .timeSeries(timeSeries?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MachineLearningDatasetArgs].
 */
@PulumiTagMarker
public class MachineLearningDatasetArgsBuilder internal constructor() {
    private var datasetName: Output<String>? = null

    private var datasetType: Output<Either<String, DatasetType>>? = null

    private var parameters: Output<DatasetCreateRequestParametersArgs>? = null

    private var registration: Output<DatasetCreateRequestRegistrationArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var skipValidation: Output<Boolean>? = null

    private var timeSeries: Output<DatasetCreateRequestTimeSeriesArgs>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The Dataset name.
     */
    @JvmName("jppgbxsacmiqaysd")
    public suspend fun datasetName(`value`: Output<String>) {
        this.datasetName = value
    }

    /**
     * @param value Specifies dataset type.
     */
    @JvmName("vnawmctjxefcfdvm")
    public suspend fun datasetType(`value`: Output<Either<String, DatasetType>>) {
        this.datasetType = value
    }

    /**
     * @param value
     */
    @JvmName("jaatcqdpjdfnbtee")
    public suspend fun parameters(`value`: Output<DatasetCreateRequestParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value
     */
    @JvmName("rdnjxvrwnpepwcto")
    public suspend fun registration(`value`: Output<DatasetCreateRequestRegistrationArgs>) {
        this.registration = value
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("rfscoccdccefskjf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Skip validation that ensures data can be loaded from the dataset before registration.
     */
    @JvmName("rgmcmtablfujtvav")
    public suspend fun skipValidation(`value`: Output<Boolean>) {
        this.skipValidation = value
    }

    /**
     * @param value
     */
    @JvmName("iwrwvopbwaecyjep")
    public suspend fun timeSeries(`value`: Output<DatasetCreateRequestTimeSeriesArgs>) {
        this.timeSeries = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("dqvgvhbtalxnjvxn")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The Dataset name.
     */
    @JvmName("cfslrdnhokfmlths")
    public suspend fun datasetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasetName = mapped
    }

    /**
     * @param value Specifies dataset type.
     */
    @JvmName("tqbnjeamgjqtxfik")
    public suspend fun datasetType(`value`: Either<String, DatasetType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasetType = mapped
    }

    /**
     * @param value Specifies dataset type.
     */
    @JvmName("hcsdyrckwvwhqxhc")
    public fun datasetType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DatasetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datasetType = mapped
    }

    /**
     * @param value Specifies dataset type.
     */
    @JvmName("ilnikfjkfrrkmups")
    public fun datasetType(`value`: DatasetType) {
        val toBeMapped = Either.ofRight<String, DatasetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datasetType = mapped
    }

    /**
     * @param value
     */
    @JvmName("dvmdtsamcuahklgl")
    public suspend fun parameters(`value`: DatasetCreateRequestParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jsjollsdxaaplnyr")
    public suspend
    fun parameters(argument: suspend DatasetCreateRequestParametersArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetCreateRequestParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value
     */
    @JvmName("njutsadsxrnskmfi")
    public suspend fun registration(`value`: DatasetCreateRequestRegistrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bynkwykiacttbhtc")
    public suspend
    fun registration(argument: suspend DatasetCreateRequestRegistrationArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetCreateRequestRegistrationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.registration = mapped
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("spuovcsbnihklnuh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Skip validation that ensures data can be loaded from the dataset before registration.
     */
    @JvmName("lqqghfvkpkrqhaxa")
    public suspend fun skipValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipValidation = mapped
    }

    /**
     * @param value
     */
    @JvmName("ivfhodefimntrcwy")
    public suspend fun timeSeries(`value`: DatasetCreateRequestTimeSeriesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeSeries = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vqghghryljumhlay")
    public suspend
    fun timeSeries(argument: suspend DatasetCreateRequestTimeSeriesArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetCreateRequestTimeSeriesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeSeries = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("vplcehqoiaxfectg")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): MachineLearningDatasetArgs = MachineLearningDatasetArgs(
        datasetName = datasetName,
        datasetType = datasetType,
        parameters = parameters,
        registration = registration,
        resourceGroupName = resourceGroupName,
        skipValidation = skipValidation,
        timeSeries = timeSeries,
        workspaceName = workspaceName,
    )
}
