@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.DatastoreTypeArm
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Machine Learning datastore object wrapped into ARM resource envelope.
 * Azure REST API version: 2020-05-01-preview. Prior API version in Azure Native 1.x: 2020-05-01-preview.
 * ## Example Usage
 * ### Create ADLS  Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         ClientId = "233d7008-b157-4354-88d1-ba191f06a900",
 *         ClientSecret = "vdvgdvdvdv",
 *         DataStoreType = "adls",
 *         DatastoreName = "adlsDatastore",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         StoreName = "stanley",
 *         TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			ClientId:          pulumi.String("233d7008-b157-4354-88d1-ba191f06a900"),
 * 			ClientSecret:      pulumi.String("vdvgdvdvdv"),
 * 			DataStoreType:     pulumi.String("adls"),
 * 			DatastoreName:     pulumi.String("adlsDatastore"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			StoreName:         pulumi.String("stanley"),
 * 			TenantId:          pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .clientId("233d7008-b157-4354-88d1-ba191f06a900")
 *             .clientSecret("vdvgdvdvdv")
 *             .dataStoreType("adls")
 *             .datastoreName("adlsDatastore")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .storeName("stanley")
 *             .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create ADLS Gen2 Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         AccountName = "nicksadlsgen2storage",
 *         ClientId = "233d7008-b157-4354-88d1-ba191f06a900",
 *         ClientSecret = "vdegbvedgeg",
 *         DataStoreType = "adls-gen2",
 *         DatastoreName = "adlsgen2Datastore",
 *         FileSystem = "testfs1",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			AccountName:       pulumi.String("nicksadlsgen2storage"),
 * 			ClientId:          pulumi.String("233d7008-b157-4354-88d1-ba191f06a900"),
 * 			ClientSecret:      pulumi.String("vdegbvedgeg"),
 * 			DataStoreType:     pulumi.String("adls-gen2"),
 * 			DatastoreName:     pulumi.String("adlsgen2Datastore"),
 * 			FileSystem:        pulumi.String("testfs1"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			TenantId:          pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .accountName("nicksadlsgen2storage")
 *             .clientId("233d7008-b157-4354-88d1-ba191f06a900")
 *             .clientSecret("vdegbvedgeg")
 *             .dataStoreType("adls-gen2")
 *             .datastoreName("adlsgen2Datastore")
 *             .fileSystem("testfs1")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Blob Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         AccountKey = "wddrfewfewsgewgrrwegwreg",
 *         AccountName = "acjainmleastus9484093746",
 *         ContainerName = "azureml-blobstore-5da947c5-53aa-41a5-bb2b-074074e73b7",
 *         DataStoreType = "blob",
 *         DatastoreName = "blobDatastore",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			AccountKey:        pulumi.String("wddrfewfewsgewgrrwegwreg"),
 * 			AccountName:       pulumi.String("acjainmleastus9484093746"),
 * 			ContainerName:     pulumi.String("azureml-blobstore-5da947c5-53aa-41a5-bb2b-074074e73b7"),
 * 			DataStoreType:     pulumi.String("blob"),
 * 			DatastoreName:     pulumi.String("blobDatastore"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .accountKey("wddrfewfewsgewgrrwegwreg")
 *             .accountName("acjainmleastus9484093746")
 *             .containerName("azureml-blobstore-5da947c5-53aa-41a5-bb2b-074074e73b7")
 *             .dataStoreType("blob")
 *             .datastoreName("blobDatastore")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Databricks File System Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         DataStoreType = "dbfs",
 *         DatastoreName = "blobDatastore",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			DataStoreType:     pulumi.String("dbfs"),
 * 			DatastoreName:     pulumi.String("blobDatastore"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .dataStoreType("dbfs")
 *             .datastoreName("blobDatastore")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create File Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         AccountKey = "wddrfewfewsgewgrrwegwreg",
 *         AccountName = "acjainmleastus9484093746",
 *         DataStoreType = "file",
 *         DatastoreName = "fileDatastore",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         ShareName = "azureml-filestore-5da947c5-53aa-41a5-bb2b-074074e73b76",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			AccountKey:        pulumi.String("wddrfewfewsgewgrrwegwreg"),
 * 			AccountName:       pulumi.String("acjainmleastus9484093746"),
 * 			DataStoreType:     pulumi.String("file"),
 * 			DatastoreName:     pulumi.String("fileDatastore"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			ShareName:         pulumi.String("azureml-filestore-5da947c5-53aa-41a5-bb2b-074074e73b76"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .accountKey("wddrfewfewsgewgrrwegwreg")
 *             .accountName("acjainmleastus9484093746")
 *             .dataStoreType("file")
 *             .datastoreName("fileDatastore")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .shareName("azureml-filestore-5da947c5-53aa-41a5-bb2b-074074e73b76")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create MySQL Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         DataStoreType = "mysqldb",
 *         DatabaseName = "dataset",
 *         DatastoreName = "mySqlDatastore",
 *         Password = "<password>",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         ServerName = "dataset-mysql-srv",
 *         UserId = "demo_user@dataset-mysql-srv",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			DataStoreType:     pulumi.String("mysqldb"),
 * 			DatabaseName:      pulumi.String("dataset"),
 * 			DatastoreName:     pulumi.String("mySqlDatastore"),
 * 			Password:          pulumi.String("<password>"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			ServerName:        pulumi.String("dataset-mysql-srv"),
 * 			UserId:            pulumi.String("demo_user@dataset-mysql-srv"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .dataStoreType("mysqldb")
 *             .databaseName("dataset")
 *             .datastoreName("mySqlDatastore")
 *             .password("<password>")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .serverName("dataset-mysql-srv")
 *             .userId("demo_user@dataset-mysql-srv")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create PostgreSQL Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         DataStoreType = "psqldb",
 *         DatabaseName = "dataset",
 *         DatastoreName = "postgreSqlDatastore",
 *         Password = "<password>",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         ServerName = "dataset-pgsql-srv",
 *         UserId = "demo_user@dataset-pgsql-srv",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			DataStoreType:     pulumi.String("psqldb"),
 * 			DatabaseName:      pulumi.String("dataset"),
 * 			DatastoreName:     pulumi.String("postgreSqlDatastore"),
 * 			Password:          pulumi.String("<password>"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			ServerName:        pulumi.String("dataset-pgsql-srv"),
 * 			UserId:            pulumi.String("demo_user@dataset-pgsql-srv"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .dataStoreType("psqldb")
 *             .databaseName("dataset")
 *             .datastoreName("postgreSqlDatastore")
 *             .password("<password>")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .serverName("dataset-pgsql-srv")
 *             .userId("demo_user@dataset-pgsql-srv")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create SQL Datastore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDatastore = new AzureNative.MachineLearningServices.MachineLearningDatastore("machineLearningDatastore", new()
 *     {
 *         DataStoreType = "sqldb",
 *         DatabaseName = "dataset",
 *         DatastoreName = "sqlDatastore",
 *         Password = "<password>",
 *         ResourceGroupName = "acjain-mleastUS2",
 *         ServerName = "dataset-azsql-srv",
 *         UserName = "demo_user",
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDatastore(ctx, "machineLearningDatastore", &machinelearningservices.MachineLearningDatastoreArgs{
 * 			DataStoreType:     pulumi.String("sqldb"),
 * 			DatabaseName:      pulumi.String("dataset"),
 * 			DatastoreName:     pulumi.String("sqlDatastore"),
 * 			Password:          pulumi.String("<password>"),
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			ServerName:        pulumi.String("dataset-azsql-srv"),
 * 			UserName:          pulumi.String("demo_user"),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastore;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDatastore = new MachineLearningDatastore("machineLearningDatastore", MachineLearningDatastoreArgs.builder()
 *             .dataStoreType("sqldb")
 *             .databaseName("dataset")
 *             .datastoreName("sqlDatastore")
 *             .password("<password>")
 *             .resourceGroupName("acjain-mleastUS2")
 *             .serverName("dataset-azsql-srv")
 *             .userName("demo_user")
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:MachineLearningDatastore sqlDatastore /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/datastores/{datastoreName}
 * ```
 * @property accountKey Account Key of storage account.
 * @property accountName The name of the storage account.
 * @property adlsResourceGroup The resource group the ADLS store belongs to. Defaults to selected resource group.
 * @property adlsSubscriptionId The ID of the subscription the ADLS store belongs to. Defaults to selected subscription.
 * @property authorityUrl Authority url used to authenticate the user.
 * @property clientId The service principal's client/application ID.
 * @property clientSecret The service principal's secret.
 * @property containerName The name of the azure blob container.
 * @property dataStoreType Specifies datastore type.
 * @property databaseName The database name.
 * @property datastoreName The Datastore name.
 * @property description The description of the datastore.
 * @property endpoint The endpoint of the server.
 * @property enforceSSL This sets the ssl value of the server. Defaults to true if not set.
 * @property fileSystem The file system name of the ADLS Gen2.
 * @property includeSecret Include datastore secret in response.
 * @property name The name of the datastore.
 * @property password The password.
 * @property port The port number.
 * @property protocol The protocol to be used
 * @property resourceGroupName Name of the resource group in which workspace is located.
 * @property resourceUrl Determines what operations will be performed.
 * @property sasToken Sas Token of storage account.
 * @property serverName The SQL/MySQL/PostgreSQL server name
 * @property shareName The name of the file share.
 * @property skipValidation Skip validation that ensures data can be loaded from the dataset before registration.
 * @property storageAccountResourceGroup The resource group of the storage account. Defaults to selected resource group
 * @property storageAccountSubscriptionId The subscription ID of the storage account. Defaults to selected subscription
 * @property storeName The ADLS store name.
 * @property tenantId The service principal Tenant ID.
 * @property userId The user ID.
 * @property userName The username of the database user.
 * @property workspaceName Name of Azure Machine Learning workspace.
 * @property workspaceSystemAssignedIdentity If set to true, datastore support data access authenticated with Workspace MSI.
 */
public data class MachineLearningDatastoreArgs(
    public val accountKey: Output<String>? = null,
    public val accountName: Output<String>? = null,
    public val adlsResourceGroup: Output<String>? = null,
    public val adlsSubscriptionId: Output<String>? = null,
    public val authorityUrl: Output<String>? = null,
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val dataStoreType: Output<Either<String, DatastoreTypeArm>>? = null,
    public val databaseName: Output<String>? = null,
    public val datastoreName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val endpoint: Output<String>? = null,
    public val enforceSSL: Output<Boolean>? = null,
    public val fileSystem: Output<String>? = null,
    public val includeSecret: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val password: Output<String>? = null,
    public val port: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceUrl: Output<String>? = null,
    public val sasToken: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val shareName: Output<String>? = null,
    public val skipValidation: Output<Boolean>? = null,
    public val storageAccountResourceGroup: Output<String>? = null,
    public val storageAccountSubscriptionId: Output<String>? = null,
    public val storeName: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val userId: Output<String>? = null,
    public val userName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
    public val workspaceSystemAssignedIdentity: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs =
        com.pulumi.azurenative.machinelearningservices.MachineLearningDatastoreArgs.builder()
            .accountKey(accountKey?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .adlsResourceGroup(adlsResourceGroup?.applyValue({ args0 -> args0 }))
            .adlsSubscriptionId(adlsSubscriptionId?.applyValue({ args0 -> args0 }))
            .authorityUrl(authorityUrl?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .dataStoreType(
                dataStoreType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .datastoreName(datastoreName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .enforceSSL(enforceSSL?.applyValue({ args0 -> args0 }))
            .fileSystem(fileSystem?.applyValue({ args0 -> args0 }))
            .includeSecret(includeSecret?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceUrl(resourceUrl?.applyValue({ args0 -> args0 }))
            .sasToken(sasToken?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .shareName(shareName?.applyValue({ args0 -> args0 }))
            .skipValidation(skipValidation?.applyValue({ args0 -> args0 }))
            .storageAccountResourceGroup(storageAccountResourceGroup?.applyValue({ args0 -> args0 }))
            .storageAccountSubscriptionId(storageAccountSubscriptionId?.applyValue({ args0 -> args0 }))
            .storeName(storeName?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 }))
            .workspaceSystemAssignedIdentity(
                workspaceSystemAssignedIdentity?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [MachineLearningDatastoreArgs].
 */
@PulumiTagMarker
public class MachineLearningDatastoreArgsBuilder internal constructor() {
    private var accountKey: Output<String>? = null

    private var accountName: Output<String>? = null

    private var adlsResourceGroup: Output<String>? = null

    private var adlsSubscriptionId: Output<String>? = null

    private var authorityUrl: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var containerName: Output<String>? = null

    private var dataStoreType: Output<Either<String, DatastoreTypeArm>>? = null

    private var databaseName: Output<String>? = null

    private var datastoreName: Output<String>? = null

    private var description: Output<String>? = null

    private var endpoint: Output<String>? = null

    private var enforceSSL: Output<Boolean>? = null

    private var fileSystem: Output<String>? = null

    private var includeSecret: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var port: Output<String>? = null

    private var protocol: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceUrl: Output<String>? = null

    private var sasToken: Output<String>? = null

    private var serverName: Output<String>? = null

    private var shareName: Output<String>? = null

    private var skipValidation: Output<Boolean>? = null

    private var storageAccountResourceGroup: Output<String>? = null

    private var storageAccountSubscriptionId: Output<String>? = null

    private var storeName: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var userId: Output<String>? = null

    private var userName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    private var workspaceSystemAssignedIdentity: Output<Boolean>? = null

    /**
     * @param value Account Key of storage account.
     */
    @JvmName("nqlrgwtkcobgkfxv")
    public suspend fun accountKey(`value`: Output<String>) {
        this.accountKey = value
    }

    /**
     * @param value The name of the storage account.
     */
    @JvmName("wjaocastcxiubjcg")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The resource group the ADLS store belongs to. Defaults to selected resource group.
     */
    @JvmName("fylmlchdhdrvlyrh")
    public suspend fun adlsResourceGroup(`value`: Output<String>) {
        this.adlsResourceGroup = value
    }

    /**
     * @param value The ID of the subscription the ADLS store belongs to. Defaults to selected subscription.
     */
    @JvmName("fdbjxditadiasyqn")
    public suspend fun adlsSubscriptionId(`value`: Output<String>) {
        this.adlsSubscriptionId = value
    }

    /**
     * @param value Authority url used to authenticate the user.
     */
    @JvmName("snpfwvanxxfduspg")
    public suspend fun authorityUrl(`value`: Output<String>) {
        this.authorityUrl = value
    }

    /**
     * @param value The service principal's client/application ID.
     */
    @JvmName("tbngcvwghlwfvmvr")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The service principal's secret.
     */
    @JvmName("qbfnikatqjkcasgr")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value The name of the azure blob container.
     */
    @JvmName("gyceowtwsnkiuaky")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Specifies datastore type.
     */
    @JvmName("gftbtwjrlkuvvgsv")
    public suspend fun dataStoreType(`value`: Output<Either<String, DatastoreTypeArm>>) {
        this.dataStoreType = value
    }

    /**
     * @param value The database name.
     */
    @JvmName("tderoxnfwgnhucgm")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The Datastore name.
     */
    @JvmName("ieqklhsxohpgktqf")
    public suspend fun datastoreName(`value`: Output<String>) {
        this.datastoreName = value
    }

    /**
     * @param value The description of the datastore.
     */
    @JvmName("xbsvbygjbneplgua")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The endpoint of the server.
     */
    @JvmName("qldeltcrvonluous")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value This sets the ssl value of the server. Defaults to true if not set.
     */
    @JvmName("beruhlcddhiymhsg")
    public suspend fun enforceSSL(`value`: Output<Boolean>) {
        this.enforceSSL = value
    }

    /**
     * @param value The file system name of the ADLS Gen2.
     */
    @JvmName("twcbylfqvmbtbvcy")
    public suspend fun fileSystem(`value`: Output<String>) {
        this.fileSystem = value
    }

    /**
     * @param value Include datastore secret in response.
     */
    @JvmName("pjryfijacdpnpori")
    public suspend fun includeSecret(`value`: Output<Boolean>) {
        this.includeSecret = value
    }

    /**
     * @param value The name of the datastore.
     */
    @JvmName("wrnastvaljcmmcuu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The password.
     */
    @JvmName("rhgccigyghltmtdw")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The port number.
     */
    @JvmName("jenjwhqcmcqefant")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value The protocol to be used
     */
    @JvmName("ejkjobkimooakrct")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("copskwjbqmdfoqog")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Determines what operations will be performed.
     */
    @JvmName("kftcnsnubmlkdtnv")
    public suspend fun resourceUrl(`value`: Output<String>) {
        this.resourceUrl = value
    }

    /**
     * @param value Sas Token of storage account.
     */
    @JvmName("mwdelaprovstwjgc")
    public suspend fun sasToken(`value`: Output<String>) {
        this.sasToken = value
    }

    /**
     * @param value The SQL/MySQL/PostgreSQL server name
     */
    @JvmName("jfcpvkyopitmrrrj")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the file share.
     */
    @JvmName("ynfyveyonkmtubsb")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value Skip validation that ensures data can be loaded from the dataset before registration.
     */
    @JvmName("tobronujtdapakfd")
    public suspend fun skipValidation(`value`: Output<Boolean>) {
        this.skipValidation = value
    }

    /**
     * @param value The resource group of the storage account. Defaults to selected resource group
     */
    @JvmName("ggypwvefnfmspmgs")
    public suspend fun storageAccountResourceGroup(`value`: Output<String>) {
        this.storageAccountResourceGroup = value
    }

    /**
     * @param value The subscription ID of the storage account. Defaults to selected subscription
     */
    @JvmName("njdwkqseoifjkmmy")
    public suspend fun storageAccountSubscriptionId(`value`: Output<String>) {
        this.storageAccountSubscriptionId = value
    }

    /**
     * @param value The ADLS store name.
     */
    @JvmName("noslfkogqsecbabw")
    public suspend fun storeName(`value`: Output<String>) {
        this.storeName = value
    }

    /**
     * @param value The service principal Tenant ID.
     */
    @JvmName("quffokuuvouidcho")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The user ID.
     */
    @JvmName("mbqbdxsvmxkgxtdt")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value The username of the database user.
     */
    @JvmName("mfuyjwgxgbcelwjr")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("luouvsqytvjywbpj")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value If set to true, datastore support data access authenticated with Workspace MSI.
     */
    @JvmName("udnbrgykuwscaplj")
    public suspend fun workspaceSystemAssignedIdentity(`value`: Output<Boolean>) {
        this.workspaceSystemAssignedIdentity = value
    }

    /**
     * @param value Account Key of storage account.
     */
    @JvmName("bailsumcxkgqsaje")
    public suspend fun accountKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value The name of the storage account.
     */
    @JvmName("dqveoftrjpxpqthh")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The resource group the ADLS store belongs to. Defaults to selected resource group.
     */
    @JvmName("cpveouawfjhbemrb")
    public suspend fun adlsResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adlsResourceGroup = mapped
    }

    /**
     * @param value The ID of the subscription the ADLS store belongs to. Defaults to selected subscription.
     */
    @JvmName("ewwypxwcxqpjpfkd")
    public suspend fun adlsSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adlsSubscriptionId = mapped
    }

    /**
     * @param value Authority url used to authenticate the user.
     */
    @JvmName("jqsodhuhbebeiwhv")
    public suspend fun authorityUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorityUrl = mapped
    }

    /**
     * @param value The service principal's client/application ID.
     */
    @JvmName("nhwondsyftfcfsie")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The service principal's secret.
     */
    @JvmName("mwwmbhxvvvcmrjvs")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The name of the azure blob container.
     */
    @JvmName("rtbhqaqhsgadluph")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Specifies datastore type.
     */
    @JvmName("mqdycphpwqsdnnqn")
    public suspend fun dataStoreType(`value`: Either<String, DatastoreTypeArm>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataStoreType = mapped
    }

    /**
     * @param value Specifies datastore type.
     */
    @JvmName("hnmmuevnulfoyviv")
    public fun dataStoreType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DatastoreTypeArm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStoreType = mapped
    }

    /**
     * @param value Specifies datastore type.
     */
    @JvmName("gissexeamxtvayye")
    public fun dataStoreType(`value`: DatastoreTypeArm) {
        val toBeMapped = Either.ofRight<String, DatastoreTypeArm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataStoreType = mapped
    }

    /**
     * @param value The database name.
     */
    @JvmName("dotwlywqiiewmuhe")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The Datastore name.
     */
    @JvmName("efbcdqmjobablfux")
    public suspend fun datastoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datastoreName = mapped
    }

    /**
     * @param value The description of the datastore.
     */
    @JvmName("yjqsqxplmmqfwcke")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The endpoint of the server.
     */
    @JvmName("rlyjmukenbtirwet")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value This sets the ssl value of the server. Defaults to true if not set.
     */
    @JvmName("mryjwlypyuxchabk")
    public suspend fun enforceSSL(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforceSSL = mapped
    }

    /**
     * @param value The file system name of the ADLS Gen2.
     */
    @JvmName("knbfgsvuidnrbitx")
    public suspend fun fileSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystem = mapped
    }

    /**
     * @param value Include datastore secret in response.
     */
    @JvmName("btcomvvqwxkncwqn")
    public suspend fun includeSecret(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeSecret = mapped
    }

    /**
     * @param value The name of the datastore.
     */
    @JvmName("jlmcjwyvtpsyfsrg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The password.
     */
    @JvmName("loyyhfmutrhadprf")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The port number.
     */
    @JvmName("aowvojjihafrdegf")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol to be used
     */
    @JvmName("dovdivhujbnxovfp")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("podgmikdwgwxcyle")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Determines what operations will be performed.
     */
    @JvmName("ixkbfbieiaghfenx")
    public suspend fun resourceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUrl = mapped
    }

    /**
     * @param value Sas Token of storage account.
     */
    @JvmName("xstvlclyjjnisvqe")
    public suspend fun sasToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasToken = mapped
    }

    /**
     * @param value The SQL/MySQL/PostgreSQL server name
     */
    @JvmName("sxvhhlhjpaynkqho")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The name of the file share.
     */
    @JvmName("cxjciusbbigrwfcy")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value Skip validation that ensures data can be loaded from the dataset before registration.
     */
    @JvmName("hssdweyaaquetrnw")
    public suspend fun skipValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipValidation = mapped
    }

    /**
     * @param value The resource group of the storage account. Defaults to selected resource group
     */
    @JvmName("qhxthawdgcogujlu")
    public suspend fun storageAccountResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountResourceGroup = mapped
    }

    /**
     * @param value The subscription ID of the storage account. Defaults to selected subscription
     */
    @JvmName("rqtgnjkanpercqle")
    public suspend fun storageAccountSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountSubscriptionId = mapped
    }

    /**
     * @param value The ADLS store name.
     */
    @JvmName("ymdvsvnyydbdropd")
    public suspend fun storeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storeName = mapped
    }

    /**
     * @param value The service principal Tenant ID.
     */
    @JvmName("xpigqikyfrcynydr")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value The user ID.
     */
    @JvmName("effrdyudujxekvth")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    /**
     * @param value The username of the database user.
     */
    @JvmName("ynaupwnngbedsbag")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("mcramnpjllceurym")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    /**
     * @param value If set to true, datastore support data access authenticated with Workspace MSI.
     */
    @JvmName("wvrcwldkqevkuous")
    public suspend fun workspaceSystemAssignedIdentity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceSystemAssignedIdentity = mapped
    }

    internal fun build(): MachineLearningDatastoreArgs = MachineLearningDatastoreArgs(
        accountKey = accountKey,
        accountName = accountName,
        adlsResourceGroup = adlsResourceGroup,
        adlsSubscriptionId = adlsSubscriptionId,
        authorityUrl = authorityUrl,
        clientId = clientId,
        clientSecret = clientSecret,
        containerName = containerName,
        dataStoreType = dataStoreType,
        databaseName = databaseName,
        datastoreName = datastoreName,
        description = description,
        endpoint = endpoint,
        enforceSSL = enforceSSL,
        fileSystem = fileSystem,
        includeSecret = includeSecret,
        name = name,
        password = password,
        port = port,
        protocol = protocol,
        resourceGroupName = resourceGroupName,
        resourceUrl = resourceUrl,
        sasToken = sasToken,
        serverName = serverName,
        shareName = shareName,
        skipValidation = skipValidation,
        storageAccountResourceGroup = storageAccountResourceGroup,
        storageAccountSubscriptionId = storageAccountSubscriptionId,
        storeName = storeName,
        tenantId = tenantId,
        userId = userId,
        userName = userName,
        workspaceName = workspaceName,
        workspaceSystemAssignedIdentity = workspaceSystemAssignedIdentity,
    )
}
