@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.OnlineEndpointArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:OnlineEndpoint string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/onlineEndpoints/{endpointName}
 * ```
 * @property endpointName Online Endpoint name.
 * @property identity Managed service identity (system assigned and/or user assigned identities)
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
 * @property location The geo-location where the resource lives
 * @property onlineEndpointProperties [Required] Additional attributes of the entity.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku Sku details required for ARM contract for Autoscaling.
 * @property tags Resource tags.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class OnlineEndpointArgs(
    public val endpointName: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val onlineEndpointProperties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.OnlineEndpointArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.OnlineEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.OnlineEndpointArgs =
        com.pulumi.azurenative.machinelearningservices.OnlineEndpointArgs.builder()
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .onlineEndpointProperties(
                onlineEndpointProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OnlineEndpointArgs].
 */
@PulumiTagMarker
public class OnlineEndpointArgsBuilder internal constructor() {
    private var endpointName: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var onlineEndpointProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.OnlineEndpointArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Online Endpoint name.
     */
    @JvmName("yqdotgoolkwqnbjx")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("edgmesxpkafpgtti")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
     */
    @JvmName("yxiexldxgjrwhsan")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vojirlsknnskljog")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("wchdprdrecjdtogv")
    public suspend
    fun onlineEndpointProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.OnlineEndpointArgs>) {
        this.onlineEndpointProperties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nhvujvykjtbbtpmu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("mrqwyfajljvwnond")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("omooalrppkskxvkh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("nwpdakhyskaenoag")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Online Endpoint name.
     */
    @JvmName("wvvnpsaehcvryycp")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("otbcfkbqxhrucscy")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("rejjshhmcqrpuknl")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
     */
    @JvmName("krvpjvwiiroijegx")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ddhxklstypxuohrb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("hqsjumcixonljeed")
    public suspend
    fun onlineEndpointProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.OnlineEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onlineEndpointProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("uxknocadpnugonoc")
    public suspend
    fun onlineEndpointProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.OnlineEndpointArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.OnlineEndpointArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.onlineEndpointProperties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qdtapscciggborso")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("icvgmwlhnawbgcay")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("yuacagxbmxxtcffl")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ygguxtpenvyxevyd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jypmgatoxkvkviel")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("ylnthgyeoescvilb")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): OnlineEndpointArgs = OnlineEndpointArgs(
        endpointName = endpointName,
        identity = identity,
        kind = kind,
        location = location,
        onlineEndpointProperties = onlineEndpointProperties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        workspaceName = workspaceName,
    )
}
