@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.RegistryCodeVersionArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CodeVersionArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CodeVersionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate Registry Code Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryCodeVersion = new AzureNative.MachineLearningServices.RegistryCodeVersion("registryCodeVersion", new()
 *     {
 *         CodeName = "string",
 *         CodeVersionProperties = new AzureNative.MachineLearningServices.Inputs.CodeVersionArgs
 *         {
 *             CodeUri = "https://blobStorage/folderName",
 *             Description = "string",
 *             IsAnonymous = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         RegistryName = "my-aml-registry",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryCodeVersion(ctx, "registryCodeVersion", &machinelearningservices.RegistryCodeVersionArgs{
 * 			CodeName: pulumi.String("string"),
 * 			CodeVersionProperties: &machinelearningservices.CodeVersionTypeArgs{
 * 				CodeUri:     pulumi.String("https://blobStorage/folderName"),
 * 				Description: pulumi.String("string"),
 * 				IsAnonymous: pulumi.Bool(false),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			RegistryName:      pulumi.String("my-aml-registry"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryCodeVersion;
 * import com.pulumi.azurenative.machinelearningservices.RegistryCodeVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryCodeVersion = new RegistryCodeVersion("registryCodeVersion", RegistryCodeVersionArgs.builder()
 *             .codeName("string")
 *             .codeVersionProperties(Map.ofEntries(
 *                 Map.entry("codeUri", "https://blobStorage/folderName"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("isAnonymous", false),
 *                 Map.entry("properties", Map.of("string", "string")),
 *                 Map.entry("tags", Map.of("string", "string"))
 *             ))
 *             .registryName("my-aml-registry")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryCodeVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/codes/{codeName}/versions/{version}
 * ```
 * @property codeName Container name.
 * @property codeVersionProperties [Required] Additional attributes of the entity.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier.
 */
public data class RegistryCodeVersionArgs(
    public val codeName: Output<String>? = null,
    public val codeVersionProperties: Output<CodeVersionArgs>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.RegistryCodeVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.RegistryCodeVersionArgs =
        com.pulumi.azurenative.machinelearningservices.RegistryCodeVersionArgs.builder()
            .codeName(codeName?.applyValue({ args0 -> args0 }))
            .codeVersionProperties(
                codeVersionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryCodeVersionArgs].
 */
@PulumiTagMarker
public class RegistryCodeVersionArgsBuilder internal constructor() {
    private var codeName: Output<String>? = null

    private var codeVersionProperties: Output<CodeVersionArgs>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Container name.
     */
    @JvmName("vfjruhdlfilailou")
    public suspend fun codeName(`value`: Output<String>) {
        this.codeName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("cfryscpnvxcrgcok")
    public suspend fun codeVersionProperties(`value`: Output<CodeVersionArgs>) {
        this.codeVersionProperties = value
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("bqavgwigscqupynu")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cumwtxrgiyclawxc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("jvltohgsrfoianxy")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Container name.
     */
    @JvmName("lataoylgitayjjlk")
    public suspend fun codeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeName = mapped
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("omdkwnvfpssicfco")
    public suspend fun codeVersionProperties(`value`: CodeVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeVersionProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("yquetrpfcldjtjwb")
    public suspend fun codeVersionProperties(argument: suspend CodeVersionArgsBuilder.() -> Unit) {
        val toBeMapped = CodeVersionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.codeVersionProperties = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("cbiwnkfgvxbuwskn")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hbblbtlmfwvrlgij")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("aacnmatveagoodve")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): RegistryCodeVersionArgs = RegistryCodeVersionArgs(
        codeName = codeName,
        codeVersionProperties = codeVersionProperties,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
        version = version,
    )
}
