@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.RegistryComponentContainerArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ComponentContainerArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ComponentContainerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate Registry Component Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryComponentContainer = new AzureNative.MachineLearningServices.RegistryComponentContainer("registryComponentContainer", new()
 *     {
 *         ComponentContainerProperties = new AzureNative.MachineLearningServices.Inputs.ComponentContainerArgs
 *         {
 *             Description = "string",
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         ComponentName = "string",
 *         RegistryName = "my-aml-registry",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryComponentContainer(ctx, "registryComponentContainer", &machinelearningservices.RegistryComponentContainerArgs{
 * 			ComponentContainerProperties: &machinelearningservices.ComponentContainerTypeArgs{
 * 				Description: pulumi.String("string"),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			ComponentName:     pulumi.String("string"),
 * 			RegistryName:      pulumi.String("my-aml-registry"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryComponentContainer;
 * import com.pulumi.azurenative.machinelearningservices.RegistryComponentContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryComponentContainer = new RegistryComponentContainer("registryComponentContainer", RegistryComponentContainerArgs.builder()
 *             .componentContainerProperties(Map.ofEntries(
 *                 Map.entry("description", "string"),
 *                 Map.entry("properties", Map.of("string", "string")),
 *                 Map.entry("tags", Map.of("string", "string"))
 *             ))
 *             .componentName("string")
 *             .registryName("my-aml-registry")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryComponentContainer string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/components/{componentName}
 * ```
 * @property componentContainerProperties [Required] Additional attributes of the entity.
 * @property componentName Container name.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class RegistryComponentContainerArgs(
    public val componentContainerProperties: Output<ComponentContainerArgs>? = null,
    public val componentName: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.RegistryComponentContainerArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.RegistryComponentContainerArgs =
        com.pulumi.azurenative.machinelearningservices.RegistryComponentContainerArgs.builder()
            .componentContainerProperties(
                componentContainerProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .componentName(componentName?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryComponentContainerArgs].
 */
@PulumiTagMarker
public class RegistryComponentContainerArgsBuilder internal constructor() {
    private var componentContainerProperties: Output<ComponentContainerArgs>? = null

    private var componentName: Output<String>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("yryogfukexcshokq")
    public suspend fun componentContainerProperties(`value`: Output<ComponentContainerArgs>) {
        this.componentContainerProperties = value
    }

    /**
     * @param value Container name.
     */
    @JvmName("vgwdyifsocxwoakw")
    public suspend fun componentName(`value`: Output<String>) {
        this.componentName = value
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("tnxxpxbbjdldkgwf")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nmcfomtpgycnnwsh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("eyrdwrpvwgyqsxad")
    public suspend fun componentContainerProperties(`value`: ComponentContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentContainerProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("xabctlbqohsufucj")
    public suspend
    fun componentContainerProperties(argument: suspend ComponentContainerArgsBuilder.() -> Unit) {
        val toBeMapped = ComponentContainerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.componentContainerProperties = mapped
    }

    /**
     * @param value Container name.
     */
    @JvmName("umgabusnoenbomfb")
    public suspend fun componentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("tyoghytjxxivleey")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hhdcvhaepnqoxkqo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): RegistryComponentContainerArgs = RegistryComponentContainerArgs(
        componentContainerProperties = componentContainerProperties,
        componentName = componentName,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
    )
}
