@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EncryptionPropertyResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.NotebookResourceInfoResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ServiceManagedResourcesSettingsResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SharedPrivateLinkResourceResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EncryptionPropertyResponse.Companion.toKotlin as encryptionPropertyResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.NotebookResourceInfoResponse.Companion.toKotlin as notebookResourceInfoResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ServiceManagedResourcesSettingsResponse.Companion.toKotlin as serviceManagedResourcesSettingsResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SharedPrivateLinkResourceResponse.Companion.toKotlin as sharedPrivateLinkResourceResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Workspace].
 */
@PulumiTagMarker
public class WorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceArgs = WorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceArgsBuilder.() -> Unit) {
        val builder = WorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Workspace {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.Workspace(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Workspace(builtJavaResource)
    }
}

/**
 * An object that represents a machine learning workspace.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2018-03-01-preview, 2020-08-01, 2020-09-01-preview, 2022-01-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:Workspace testworkspace /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}
 * ```
 */
public class Workspace internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.Workspace,
) : KotlinCustomResource(javaResource, WorkspaceMapper) {
    /**
     * The flag to indicate whether to allow public access when behind VNet.
     */
    public val allowPublicAccessWhenBehindVnet: Output<Boolean>?
        get() = javaResource.allowPublicAccessWhenBehindVnet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARM id of the application insights associated with this workspace.
     */
    public val applicationInsights: Output<String>?
        get() = javaResource.applicationInsights().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARM id of the container registry associated with this workspace.
     */
    public val containerRegistry: Output<String>?
        get() = javaResource.containerRegistry().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of this workspace.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Url for the discovery service to identify regional endpoints for machine learning experimentation services
     */
    public val discoveryUrl: Output<String>?
        get() = javaResource.discoveryUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The encryption settings of Azure ML workspace.
     */
    public val encryption: Output<EncryptionPropertyResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    encryptionPropertyResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The friendly name for this workspace. This name in mutable
     */
    public val friendlyName: Output<String>?
        get() = javaResource.friendlyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The flag to signal HBI data in the workspace and reduce diagnostic data collected by the service
     */
    public val hbiWorkspace: Output<Boolean>?
        get() = javaResource.hbiWorkspace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identity of the resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The compute name for image build
     */
    public val imageBuildCompute: Output<String>?
        get() = javaResource.imageBuildCompute().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created
     */
    public val keyVault: Output<String>?
        get() = javaResource.keyVault().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The URI associated with this workspace that machine learning flow must point at to set up tracking.
     */
    public val mlFlowTrackingUri: Output<String>
        get() = javaResource.mlFlowTrackingUri().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The notebook info of Azure ML workspace.
     */
    public val notebookInfo: Output<NotebookResourceInfoResponse>
        get() = javaResource.notebookInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                notebookResourceInfoResponseToKotlin(args0)
            })
        })

    /**
     * The user assigned identity resource id that represents the workspace identity.
     */
    public val primaryUserAssignedIdentity: Output<String>?
        get() = javaResource.primaryUserAssignedIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of private endpoint connections in the workspace.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Count of private connections in the workspace
     */
    public val privateLinkCount: Output<Int>
        get() = javaResource.privateLinkCount().applyValue({ args0 -> args0 })

    /**
     * The current deployment state of workspace resource. The provisioningState is to indicate states for resource provisioning.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Whether requests from Public Network are allowed.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The service managed resource settings.
     */
    public val serviceManagedResourcesSettings: Output<ServiceManagedResourcesSettingsResponse>?
        get() = javaResource.serviceManagedResourcesSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serviceManagedResourcesSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the managed resource group created by workspace RP in customer subscription if the workspace is CMK workspace
     */
    public val serviceProvisionedResourceGroup: Output<String>
        get() = javaResource.serviceProvisionedResourceGroup().applyValue({ args0 -> args0 })

    /**
     * The list of shared private link resources in this workspace.
     */
    public val sharedPrivateLinkResources: Output<List<SharedPrivateLinkResourceResponse>>?
        get() = javaResource.sharedPrivateLinkResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        sharedPrivateLinkResourceResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The sku of the workspace.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created
     */
    public val storageAccount: Output<String>?
        get() = javaResource.storageAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If the storage associated with the workspace has hierarchical namespace(HNS) enabled.
     */
    public val storageHnsEnabled: Output<Boolean>
        get() = javaResource.storageHnsEnabled().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Contains resource tags defined as key/value pairs.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The tenant id associated with this workspace.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Enabling v1_legacy_mode may prevent you from using features provided by the v2 API.
     */
    public val v1LegacyMode: Output<Boolean>?
        get() = javaResource.v1LegacyMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The immutable id associated with this workspace.
     */
    public val workspaceId: Output<String>
        get() = javaResource.workspaceId().applyValue({ args0 -> args0 })
}

public object WorkspaceMapper : ResourceMapper<Workspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.Workspace::class == javaResource::class

    override fun map(javaResource: Resource): Workspace = Workspace(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.Workspace,
    )
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workspace].
 */
public suspend fun workspace(name: String, block: suspend WorkspaceResourceBuilder.() -> Unit):
    Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspace(name: String): Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
