@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The parameter defining how if AutoML should handle short time series.
 */
public enum class ShortSeriesHandlingConfiguration(
    public val javaValue:
    com.pulumi.azurenative.machinelearningservices.enums.ShortSeriesHandlingConfiguration,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.ShortSeriesHandlingConfiguration> {
    /**
     * Represents no/null value.
     */
    None(com.pulumi.azurenative.machinelearningservices.enums.ShortSeriesHandlingConfiguration.None),

    /**
     * Short series will be padded if there are no long series, otherwise short series will be dropped.
     */
    Auto(com.pulumi.azurenative.machinelearningservices.enums.ShortSeriesHandlingConfiguration.Auto),

    /**
     * All the short series will be padded.
     */
    Pad(com.pulumi.azurenative.machinelearningservices.enums.ShortSeriesHandlingConfiguration.Pad),

    /**
     * All the short series will be dropped.
     */
    Drop(com.pulumi.azurenative.machinelearningservices.enums.ShortSeriesHandlingConfiguration.Drop),
    ;

    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.enums.ShortSeriesHandlingConfiguration =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.ShortSeriesHandlingConfiguration):
            ShortSeriesHandlingConfiguration =
            ShortSeriesHandlingConfiguration.values().first { it.javaValue == javaType }
    }
}
