@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The meta-learner is a model trained on the output of the individual heterogeneous models.
 */
public enum class StackMetaLearnerType(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.StackMetaLearnerType,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.StackMetaLearnerType> {
    None(com.pulumi.azurenative.machinelearningservices.enums.StackMetaLearnerType.None),

    /**
     * Default meta-learners are LogisticRegression for classification tasks.
     */
    LogisticRegression(com.pulumi.azurenative.machinelearningservices.enums.StackMetaLearnerType.LogisticRegression),

    /**
     * Default meta-learners are LogisticRegression for classification task when CV is on.
     */
    LogisticRegressionCV(com.pulumi.azurenative.machinelearningservices.enums.StackMetaLearnerType.LogisticRegressionCV),
    LightGBMClassifier(com.pulumi.azurenative.machinelearningservices.enums.StackMetaLearnerType.LightGBMClassifier),

    /**
     * Default meta-learners are LogisticRegression for regression task.
     */
    ElasticNet(com.pulumi.azurenative.machinelearningservices.enums.StackMetaLearnerType.ElasticNet),

    /**
     * Default meta-learners are LogisticRegression for regression task when CV is on.
     */
    ElasticNetCV(com.pulumi.azurenative.machinelearningservices.enums.StackMetaLearnerType.ElasticNetCV),
    LightGBMRegressor(com.pulumi.azurenative.machinelearningservices.enums.StackMetaLearnerType.LightGBMRegressor),
    LinearRegression(com.pulumi.azurenative.machinelearningservices.enums.StackMetaLearnerType.LinearRegression),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.StackMetaLearnerType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.StackMetaLearnerType):
            StackMetaLearnerType = StackMetaLearnerType.values().first { it.javaValue == javaType }
    }
}
