@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AccountKeyDatastoreSecretsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Datastore account key secrets.
 * @property key Storage account key.
 * @property secretsType Enum to determine the datastore secrets type.
 * Expected value is 'AccountKey'.
 */
public data class AccountKeyDatastoreSecretsArgs(
    public val key: Output<String>? = null,
    public val secretsType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AccountKeyDatastoreSecretsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.AccountKeyDatastoreSecretsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AccountKeyDatastoreSecretsArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .secretsType(secretsType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountKeyDatastoreSecretsArgs].
 */
@PulumiTagMarker
public class AccountKeyDatastoreSecretsArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var secretsType: Output<String>? = null

    /**
     * @param value Storage account key.
     */
    @JvmName("afiqlfwqkwosnchs")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Enum to determine the datastore secrets type.
     * Expected value is 'AccountKey'.
     */
    @JvmName("qbbjsuwhbqfvahvs")
    public suspend fun secretsType(`value`: Output<String>) {
        this.secretsType = value
    }

    /**
     * @param value Storage account key.
     */
    @JvmName("tsbdvumktxglddvd")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Enum to determine the datastore secrets type.
     * Expected value is 'AccountKey'.
     */
    @JvmName("irgjewnycmhascpm")
    public suspend fun secretsType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretsType = mapped
    }

    internal fun build(): AccountKeyDatastoreSecretsArgs = AccountKeyDatastoreSecretsArgs(
        key = key,
        secretsType = secretsType ?: throw PulumiNullFieldException("secretsType"),
    )
}
