@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AllNodesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * All nodes means the service will be running on all of the nodes of the job
 * @property nodesValueType The enumerated types for the nodes value
 * Expected value is 'All'.
 */
public data class AllNodesArgs(
    public val nodesValueType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AllNodesArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.AllNodesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AllNodesArgs.builder()
            .nodesValueType(nodesValueType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AllNodesArgs].
 */
@PulumiTagMarker
public class AllNodesArgsBuilder internal constructor() {
    private var nodesValueType: Output<String>? = null

    /**
     * @param value The enumerated types for the nodes value
     * Expected value is 'All'.
     */
    @JvmName("wsodfrbddfqjrdqg")
    public suspend fun nodesValueType(`value`: Output<String>) {
        this.nodesValueType = value
    }

    /**
     * @param value The enumerated types for the nodes value
     * Expected value is 'All'.
     */
    @JvmName("puwcxaerycsiqhvj")
    public suspend fun nodesValueType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodesValueType = mapped
    }

    internal fun build(): AllNodesArgs = AllNodesArgs(
        nodesValueType = nodesValueType ?: throw PulumiNullFieldException("nodesValueType"),
    )
}
